//-----ScriptName=Set_daysInMonth
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Set_daysInMonth for main script method
//---------------------------------------------------------------------------------------------
void Set_daysInMonth ()
{
	uint currentHandle;
	int month, isLeapYear, days, day;
	
	currentHandle = VariableIDs.RealTimeClock_Set_Month;
	smRead(currentHandle, month);
	
	currentHandle = VariableIDs.RealTimeClock_Set_isLeapYear;
	smRead(currentHandle, isLeapYear);
	
	currentHandle = VariableIDs.RealTimeClock_Set_Day;
	smRead(currentHandle, day);
	
	switch(month)
	{
		case 1:
			days = 31;
		break;
		
		case 2:
			if(isLeapYear==1)
			{
				days = 29;
			}
			else
			{
				days = 28;
			}
		break;
		
		case 3:
			days = 31;
		break;
		
		case 4:
			days = 30;
		break;
		
		case 5:
			days = 31;
		break;
		
		case 6:
			days = 30;
		break;
		
		case 7:
			days = 31;
		break;
		
		case 8:
			days = 31;
		break;
		
		case 9:
			days = 30;
		break;
		
		case 10:
			days = 31;
		break;
		
		case 11:
			days = 30;
		break;
		
		case 12:
			days = 31;
		break;
		
		default:
			days = 31;
	}
	
	currentHandle = VariableIDs.RealTimeClock_Set_daysInMonth;
	smWrite(currentHandle, days);
	
	day = day % ( days + 1 );
	
	currentHandle = VariableIDs.RealTimeClock_Set_Day;
	smWrite(currentHandle, day);
}

//-----ScriptName=Set_isLeapYear
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Set_isLeapYear for main script method
//---------------------------------------------------------------------------------------------
void Set_isLeapYear ()
{
	uint currentHandle;
	int year, isLeapYear;
	
	currentHandle = VariableIDs.RealTimeClock_Set_Year;
	smRead(currentHandle, year);
	
	if( ( year % 400 ) == 0 )
	{
		isLeapYear = 1;
	}
	else if( ( year % 100 ) == 0 )
	{
		isLeapYear = 0;
	}
	else if( ( year % 4 ) == 0 )
	{
		isLeapYear = 1;
	}
	else
	{
		isLeapYear = 0;
	}
	
	currentHandle = VariableIDs.RealTimeClock_Set_isLeapYear;
	smWrite(currentHandle, isLeapYear);
	
	Set_daysInMonth();
}

//-----ScriptName=Move Menu
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as $MoveScrollWindow2$ for main script method
//---------------------------------------------------------------------------------------------
int MenuCurrentPosX = 83;
int MenuCurrentPosY = -180;
int MenuTargetPosY = 30;
int MenuTargetPosYShow = 30;
int MenuTargetPosYHide = -180;

int MenuSweepSize = 42;

void MoveMenuUp ()
{
	MenuTargetPosY = MenuTargetPosYShow;
	sendEvent(EventIDs.TR_MoveMenu);
	sendEvent(EventIDs.SettingsMenu_Rollovers_6);
}

void MoveMenuDown ()
{
	MenuTargetPosY = MenuTargetPosYHide;
	sendEvent(EventIDs.TR_MoveMenu);
	sendEvent(EventIDs.SettingsMenu_Rollovers_5);
}

void MoveMenu () 
{
double location=0;
smRead (VariableIDs.CANPort1_Address,location);

    if (MenuCurrentPosY != MenuTargetPosY)		// check if at target
	{
		if ( MenuCurrentPosY < MenuTargetPosY)
		{
			MenuCurrentPosY += MenuSweepSize;
		}
		else if ( MenuCurrentPosY > MenuTargetPosY)
		{
			MenuCurrentPosY -= MenuSweepSize;
		}
		
		if (location==161)
		{
			screenApiMove(ScreenObjectIDs.CW_Menu,MenuCurrentPosX, MenuCurrentPosY);
			processScreenApi();
		}
		else
		{
			screenApiMove(ScreenObjectIDs.CW_Menu,MenuCurrentPosX, MenuCurrentPosY);
			processScreenApi();
		}
		
	}
	else
	{
		sendEvent(EventIDs.TR_MenuAtTarget);
		if (MenuCurrentPosY == MenuTargetPosYShow)
		{
			sendEvent(EventIDs.TR_ShowMenu);
		}
		else
		{
			sendEvent(EventIDs.TR_Exit_CloseMenu);
			sendEvent(EventIDs.SettingsMenu_Rollovers_OFF);
		}
	}
}


//-----ScriptName=Job Log Write
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Job_Log_Write for main script method
//---------------------------------------------------------------------------------------------
void Job_Log_Write () 
{
   double year, month, day, hour, minute, job_hour, job_minute, job_second, pto_hour, pto_minute, pto_second, fuel_start, fuel_end, job_fuel;
   string filename, job_record, job_name, job_date, job_record_time, job_duration, pto_duration;
   file f;
   
   smRead( VariableIDs.RealTimeClock_Year, year);
   smRead( VariableIDs.RealTimeClock_Month, month);
   smRead( VariableIDs.RealTimeClock_Day, day);
   smRead( VariableIDs.RealTimeClock_Hour, hour);
   smRead( VariableIDs.RealTimeClock_Minute, minute);
   smRead( VariableIDs.JOB_TIMER_Hours, job_hour);
   smRead( VariableIDs.JOB_TIMER_Minutes, job_minute);
   smRead( VariableIDs.JOB_TIMER_Seconds, job_second);
   smRead( VariableIDs.PTO_TIMER_Hours, pto_hour);
   smRead( VariableIDs.PTO_TIMER_Minutes, pto_minute);
   smRead( VariableIDs.PTO_TIMER_Seconds, pto_second);
   smRead( VariableIDs.Fuel_Job_Start, fuel_start);
   smRead( VariableIDs.J1939_Engine_Total_Fuel_Used, fuel_end);   
   cultureGetString( StringIDs.Job_Name,job_name,0);
   
//Add to job_record
   
   job_record=job_name+","+month+"/"+day+"/"+year+","+hour+":";
   
   if( minute < 10)
   	{
   		job_record += "0";
	}
	
	job_record += minute+","+job_hour+":";
	
	if( job_minute < 10)
	{
		job_record += "0";
	}
	
	job_record += job_minute+":";
	
	if( job_second < 10)
	{
		job_record += "0";
	}
	
	job_record += job_second+","+pto_hour+":";
	
	if( pto_minute < 10)
	{
		job_record += "0";
	}
	
	job_record += pto_minute+":";
	
	if( pto_second < 10)
	{
		job_record += "0";
	}
	
	job_record += pto_second+",";

	job_fuel=(fuel_end-fuel_start)/3.785;
	
	job_record += job_fuel+"\n";


//job_date
	job_date=month+"/"+day+"/"+year;
    cultureSetString (StringIDs.Job_Date,job_date,true);

//job_record_time
	job_record_time=hour+":";
   
	if( minute < 10)
   		{
   			job_record_time += "0";
		}
	
	job_record_time += minute;
    cultureSetString (StringIDs.Job_Record_Time,job_record_time,true);

//job_duration
	job_duration=job_hour+":";
   
	if( job_minute < 10)
   		{
   			job_duration += "0";
		}
	
	job_duration += job_minute+":";

	if( job_second < 10)
	{
		job_duration += "0";
	}
	
	job_duration += job_second;

    cultureSetString (StringIDs.Job_Duration,job_duration,true);

//pto_duration
	pto_duration=pto_hour+":";
   
	if( pto_minute < 10)
   		{
   			pto_duration += "0";
		}
	
	pto_duration += pto_minute+":";

	if( pto_second < 10)
	{
		pto_duration += "0";
	}
	
	pto_duration += pto_second;

    cultureSetString (StringIDs.PTO_Duration,pto_duration,true);

//job_fuel_used
	smWrite( VariableIDs.Job_Fuel_Used, job_fuel);
	
//Write File

	filename="job_log.csv";

	if ( statFile(filename)==false)
		{
		if( f.open(filename, "w") >= 0)
			{
				f.writeString("Job ID,Date,Time,Job Time,PTO Time,Fuel Consumed (gal)\n");
	        	f.writeString(job_record);
	            f.close();
			}
		}
	else
		{
		if( f.open(filename, "a") >= 0 )
		   	{
		       	f.writeString(job_record);
		        f.close();
	       	}
		}	

    cultureSetString (StringIDs.Latest_Job_Info,job_record,true);

}




//-----ScriptName=Job Name Init
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Job_Name_Init for main script method
//---------------------------------------------------------------------------------------------
void Job_Name_Init () 
{
    cultureSetString (StringIDs.Job_Name,"",true);
    cultureSetString (StringIDs.Latest_Job_Info,"",true);
}

//-----ScriptName=Job Report Download
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Job_Report_Download for main script method
//---------------------------------------------------------------------------------------------
void Job_Report_Download () 
{
	mountUSB( EventIDs.mountUSBcomplete );	
	sendEvent(EventIDs.TR_Delay_2);
}

void Job_Report_Download_2 () 
{
 	copyToUSB("job_log.csv", EventIDs.GoToDownloadComplete, EventIDs.USB_Not_Connected );
	unmountUSB( EventIDs.copyToUSBcomplete );	
}


//-----ScriptName=Delete Job Report
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Delete_Job_Report for main script method
//---------------------------------------------------------------------------------------------
void Delete_Job_Report () 
{
 	deleteFile("job_log.csv", EventIDs.jobReportDeleted );   
}

//-----ScriptName=SCR MVEC Locations
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as MVEC_Locations for main script method
//---------------------------------------------------------------------------------------------
void MVEC_Locations () 
{
	int location;
	string mvec_locationname;
    smRead (VariableIDs.MVEC_Location_Names,location);
	switch(location)
		{
			//R260 Locations
			case 220000:
			mvec_locationname="LIFT IN";
			break;
			
			case 220001:
			mvec_locationname="LIFT OUT";
			break;
			
			case 220002:
			mvec_locationname="TILT UP";
			break;
			
			case 220003:
			mvec_locationname="TILT DOWN";
			break;
			
			case 220004:
			mvec_locationname="BOOM UP";
			break;
			
			case 220005:
			mvec_locationname="BOOM DOWN";
			break;
			
			case 220006:
			mvec_locationname="NOT USED";
			break;
			
			case 220007:
			mvec_locationname="NOT USED";
			break;
			
			case 220008:
			mvec_locationname="FOLD UP";
			break;
			
			case 220009:
			mvec_locationname="FOLD DOWN";
			break;
			
			case 220010:
			mvec_locationname="LEFT WINCH IN";
			break;
			
			case 220011:
			mvec_locationname="LEFT WINCH OUT";
			break;
			
			case 220012:
			mvec_locationname="RIGHT WINCH IN";
			break;
			
			case 220013:
			mvec_locationname="RIGHT WINCH OUT";
			break;
			
			case 220014:
			mvec_locationname="BOOM OUT";
			break;
			
			case 220015:
			mvec_locationname="BOOM IN";
			break;

			case 220016:
			mvec_locationname="NOT USED";
			break;
			
			case 220020:
			mvec_locationname="SUPPLY VOLTAGE";
			break;
			
			case 220018:
			mvec_locationname="NOT USED";
			break;			

			//mVEC1 Locations
			case 230100:
			case 230116:
			mvec_locationname="PASSENGER DOCK";
			break;
			
			case 230101:
			case 230119:
			mvec_locationname="RIGHT TURN";
			break;

			case 230102:
			case 230122:
			mvec_locationname="BRAKE";
			break;

			case 230103:
			case 230117:
			mvec_locationname="REVERSE";
			break;

			case 230104:
			case 230123:
			mvec_locationname="UNDERLIFT LIGHTS";
			break;

			case 230105:
			case 230121:
			mvec_locationname="IGNITION OUT";
			break;

			case 230106:
			case 230118:
			mvec_locationname="PTO";
			break;

			case 230107:
			case 230120:
			case 230125:
			mvec_locationname="NOT USED";
			break;

			case 230124:
			mvec_locationname="Communication";
			break;

			//mVEC2 Locations
			case 230200:
			case 230216:
			mvec_locationname="MARKERS";
			break;
			
			case 230201:
			case 230219:
			mvec_locationname="UPPER LIGHTS";
			break;

			case 230202:
			case 230222:
			mvec_locationname="MAIN BEACON";
			break;

			case 230203:
			case 230217:
			mvec_locationname="AUX BEACON";
			break;

			case 230204:
			case 230223:
			mvec_locationname="WORK UP LIGHTS";
			break;

			case 230205:
			case 230221:
			mvec_locationname="CONTROLS POWER";
			break;

			case 230206:
			case 230218:
			mvec_locationname="MARKER FLASHERS";
			break;

			case 230207:
			case 230220:
			mvec_locationname="TOOLBOX LIGHTS";
			break;

			case 230224:
			mvec_locationname="Communication";
			break;

			case 230225:
			mvec_locationname="NOT USED";
			break;

			//mVEC3 Locations
			case 230300:
			case 230316:
			mvec_locationname="TAIL LIGHTS";
			break;
			
			case 230301:
			case 230319:
			mvec_locationname="BOOM LIGHTS";
			break;

			case 230302:
			case 230322:
			mvec_locationname="DRIVERS DOCK";
			break;

			case 230303:
			case 230317:
			mvec_locationname="SWIVEL LIGHTS";
			break;

			case 230304:
			case 230323:
			mvec_locationname="LEFT TURN";
			break;

			case 230305:
			case 230321:
			mvec_locationname="AUX 1";
			break;

			case 230306:
			case 230318:
			mvec_locationname="AUX 2";
			break;
			
			case 230307:
			case 230320:
			case 230325:
			mvec_locationname="NOT USED";
			break;

			case 230324:
			mvec_locationname="Communication";
			break;

			default:
			mvec_locationname="";
			break;
		}
	cultureSetString(StringIDs.MVEC_Location_Name,mvec_locationname,true);
}

//-----ScriptName=SCR_BatterySource
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as SCR_BatterySource for main script method
//---------------------------------------------------------------------------------------------
void SCR_BatterySource () 
{
	double batterySource;
	
	if (smRead (VariableIDs.J1939_Engine_Alternator_Potential, batterySource))
   		{
			smWrite(VariableIDs.Battery_Source, 0);
		}
	else if (smRead (VariableIDs.J1939_Engine_Battery_Potential_Voltage, batterySource))
		{
			smWrite(VariableIDs.Battery_Source, 1);
		}
	else if (smRead (VariableIDs.J1939_Engine_Electrical_Potential_Voltage, batterySource))
		{
			smWrite(VariableIDs.Battery_Source, 2);
		}

}

//-----ScriptName=ServRemDays
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as ServRemDays for main script method
//---------------------------------------------------------------------------------------------
void ServRemDays () 
{
	uint currentDate;
	uint y,m,d;
	smRead (VariableIDs.RealTimeClock_Year,y);
	smRead (VariableIDs.RealTimeClock_Month,m);
	smRead (VariableIDs.RealTimeClock_Day,d);
	currentDate = g (y,m,d);
	smWrite (VariableIDs.ServRemCurrentDate, currentDate);  
}

uint g ( uint y, uint m, uint d)
{
	m = (m+9) % 12;
	y = y - m/10;
	return 365*y + y/4 - y/100 + y/400 + (m*306 + 5)/10 + ( d - 1 );
}


//-----ScriptName=ServRemPopUpControl
//Handles
uint  [] HNDL_ServRem_Expired(20);

const uint8  k_ServRemActive = 20;
uint8 [] ServRemActive(k_ServRemActive);

int [] activeServiceReminders(20);		// initialize to -1
int [] ackServiceReminders(20);		// initialize to 0
int totalServRemActive;
int [] HNDL_ServRem_Init(20);

//uint  [] HNDL_ServRem_Hours_Target(3);
//uint  [] HNDL_ServRem_Hours_Remainder(3);
//uint  [] ServRem_IDs = { 11,15,16 };
//uint HNDL_Engine_Hours;

uint  [] HNDL_ServRem_Days_Target(20);
uint  [] HNDL_ServRem_Days_Remainder(20);
uint  [] ServRem_Days_IDs = { 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20 };
uint  HNDL_ServRem_CurrentDate;

//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as ServRemPopUpControl for main script method
//---------------------------------------------------------------------------------------------
void ServRemPopUpControl () 
{
	for (uint i = 0; i < k_ServRemActive; ++i)
	smRead(HNDL_ServRem_Expired[i], ServRemActive[i]);
}
	
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as ServRemPopUpControl_Initialize for main script method
//---------------------------------------------------------------------------------------------
void ServRemPopUpControl_Initialize () 
{
    HNDL_ServRem_Expired[0] = VariableIDs.ServRemActive1;
    HNDL_ServRem_Expired[1] = VariableIDs.ServRemActive2;
    HNDL_ServRem_Expired[2] = VariableIDs.ServRemActive3;
    HNDL_ServRem_Expired[3] = VariableIDs.ServRemActive4;
    HNDL_ServRem_Expired[4] = VariableIDs.ServRemActive5;
    HNDL_ServRem_Expired[5] = VariableIDs.ServRemActive6;
    HNDL_ServRem_Expired[6] = VariableIDs.ServRemActive7;
    HNDL_ServRem_Expired[7] = VariableIDs.ServRemActive8;
    HNDL_ServRem_Expired[8] = VariableIDs.ServRemActive9;

    HNDL_ServRem_Expired[9] = VariableIDs.ServRemActive10;     //Rotator Only
    HNDL_ServRem_Expired[10] = VariableIDs.ServRemActive11;    //Rotator Only

    HNDL_ServRem_Expired[11] = VariableIDs.ServRemActive12;
    HNDL_ServRem_Expired[12] = VariableIDs.ServRemActive13;
    HNDL_ServRem_Expired[13] = VariableIDs.ServRemActive14;
    HNDL_ServRem_Expired[14] = VariableIDs.ServRemActive15;
    HNDL_ServRem_Expired[15] = VariableIDs.ServRemActive16;
    HNDL_ServRem_Expired[16] = VariableIDs.ServRemActive17;
    HNDL_ServRem_Expired[17] = VariableIDs.ServRemActive18;
    HNDL_ServRem_Expired[18] = VariableIDs.ServRemActive19;

    HNDL_ServRem_Expired[19] = VariableIDs.ServRemActive20;    //Rotator Only

	for (int i=0; i<20; i++)
	{
		activeServiceReminders[i]=-1;
		ackServiceReminders[i]=0;
	}

    HNDL_ServRem_Init[0] = VariableIDs.ServRemInit1;
    HNDL_ServRem_Init[1] = VariableIDs.ServRemInit2;
    HNDL_ServRem_Init[2] = VariableIDs.ServRemInit3;
    HNDL_ServRem_Init[3] = VariableIDs.ServRemInit4;
    HNDL_ServRem_Init[4] = VariableIDs.ServRemInit5;
    HNDL_ServRem_Init[5] = VariableIDs.ServRemInit6;
    HNDL_ServRem_Init[6] = VariableIDs.ServRemInit7;
    HNDL_ServRem_Init[7] = VariableIDs.ServRemInit8;
    HNDL_ServRem_Init[8] = VariableIDs.ServRemInit9;
    HNDL_ServRem_Init[9] = VariableIDs.ServRemInit10;     //Rotator Only
    HNDL_ServRem_Init[10] = VariableIDs.ServRemInit11;    //Rotator Only
    HNDL_ServRem_Init[11] = VariableIDs.ServRemInit12;
    HNDL_ServRem_Init[12] = VariableIDs.ServRemInit13;
    HNDL_ServRem_Init[13] = VariableIDs.ServRemInit14;
    HNDL_ServRem_Init[14] = VariableIDs.ServRemInit15;
    HNDL_ServRem_Init[15] = VariableIDs.ServRemInit16;
    HNDL_ServRem_Init[16] = VariableIDs.ServRemInit17;
    HNDL_ServRem_Init[17] = VariableIDs.ServRemInit18;
    HNDL_ServRem_Init[18] = VariableIDs.ServRemInit19;
    HNDL_ServRem_Init[19] = VariableIDs.ServRemInit20;    //Rotator Only
	
// 	HNDL_ServRem_Hours_Target[0] = VariableIDs.ServRemTargetHours11;     //Rotator Only
//	HNDL_ServRem_Hours_Target[1] = VariableIDs.ServRemTargetHours15;	
//	HNDL_ServRem_Hours_Target[2] = VariableIDs.ServRemTargetHours16;
//	HNDL_ServRem_Hours_Remainder[0] = VariableIDs.ServRemRemainder11;    //Rotator Only
//	HNDL_ServRem_Hours_Remainder[1] = VariableIDs.ServRemRemainder15;
//	HNDL_ServRem_Hours_Remainder[2] = VariableIDs.ServRemRemainder16;
//	HNDL_Engine_Hours = VariableIDs.J1939_Engine_Engine_Total_Hours_of_Operation;

	HNDL_ServRem_Days_Target[0] = VariableIDs.ServRemTargetDate1;
	HNDL_ServRem_Days_Target[1] = VariableIDs.ServRemTargetDate2;
	HNDL_ServRem_Days_Target[2] = VariableIDs.ServRemTargetDate3;
	HNDL_ServRem_Days_Target[3] = VariableIDs.ServRemTargetDate4;
	HNDL_ServRem_Days_Target[4] = VariableIDs.ServRemTargetDate5;
	HNDL_ServRem_Days_Target[5] = VariableIDs.ServRemTargetDate6;
	HNDL_ServRem_Days_Target[6] = VariableIDs.ServRemTargetDate7;
	HNDL_ServRem_Days_Target[7] = VariableIDs.ServRemTargetDate8;
	HNDL_ServRem_Days_Target[8] = VariableIDs.ServRemTargetDate9;
	HNDL_ServRem_Days_Target[9] = VariableIDs.ServRemTargetDate10;     //Rotator Only
	HNDL_ServRem_Days_Target[10] = VariableIDs.ServRemTargetDate11;    //Rotator Only
	HNDL_ServRem_Days_Target[11] = VariableIDs.ServRemTargetDate12;
	HNDL_ServRem_Days_Target[12] = VariableIDs.ServRemTargetDate13;
	HNDL_ServRem_Days_Target[13] = VariableIDs.ServRemTargetDate14;
	HNDL_ServRem_Days_Target[14] = VariableIDs.ServRemTargetDate15;
	HNDL_ServRem_Days_Target[15] = VariableIDs.ServRemTargetDate16;
	HNDL_ServRem_Days_Target[16] = VariableIDs.ServRemTargetDate17;
	HNDL_ServRem_Days_Target[17] = VariableIDs.ServRemTargetDate18;
	HNDL_ServRem_Days_Target[18] = VariableIDs.ServRemTargetDate19;
	HNDL_ServRem_Days_Target[19] = VariableIDs.ServRemTargetDate20;    //Rotator Only

	HNDL_ServRem_Days_Remainder[0] = VariableIDs.ServRemRemainder1;
	HNDL_ServRem_Days_Remainder[1] = VariableIDs.ServRemRemainder2;
	HNDL_ServRem_Days_Remainder[2] = VariableIDs.ServRemRemainder3;
	HNDL_ServRem_Days_Remainder[3] = VariableIDs.ServRemRemainder4;
	HNDL_ServRem_Days_Remainder[4] = VariableIDs.ServRemRemainder5;
	HNDL_ServRem_Days_Remainder[5] = VariableIDs.ServRemRemainder6;
	HNDL_ServRem_Days_Remainder[6] = VariableIDs.ServRemRemainder7;
	HNDL_ServRem_Days_Remainder[7] = VariableIDs.ServRemRemainder8;
	HNDL_ServRem_Days_Remainder[8] = VariableIDs.ServRemRemainder9;
	HNDL_ServRem_Days_Remainder[9] = VariableIDs.ServRemRemainder10;     //Rotator Only
	HNDL_ServRem_Days_Remainder[10] = VariableIDs.ServRemRemainder11;     //Rotator Only
	HNDL_ServRem_Days_Remainder[11] = VariableIDs.ServRemRemainder12;
	HNDL_ServRem_Days_Remainder[12] = VariableIDs.ServRemRemainder13;
	HNDL_ServRem_Days_Remainder[13] = VariableIDs.ServRemRemainder14;
	HNDL_ServRem_Days_Remainder[14] = VariableIDs.ServRemRemainder15;
	HNDL_ServRem_Days_Remainder[15] = VariableIDs.ServRemRemainder16;
	HNDL_ServRem_Days_Remainder[16] = VariableIDs.ServRemRemainder17;
	HNDL_ServRem_Days_Remainder[17] = VariableIDs.ServRemRemainder18;
	HNDL_ServRem_Days_Remainder[18] = VariableIDs.ServRemRemainder19;
	HNDL_ServRem_Days_Remainder[19] = VariableIDs.ServRemRemainder20;    //Rotator Only

	HNDL_ServRem_CurrentDate = VariableIDs.ServRemCurrentDate;	
}

void ServiceReminderExpired (int index)
{
	int i=0;
	
	// check if already in list
	for ( i=0; i<20; i++)
	{
		if(	activeServiceReminders[i]==index)
			{
				return;
			}
	}

	// incre total active
	totalServRemActive++;	

	for ( i=0; i<20; i++)
	{
		if(	activeServiceReminders[i]==-1)
			{
				activeServiceReminders[i]=index;
				break;
			}
	}
		
	// update data
	smWrite(VariableIDs.ServRemPopupData,index);
	smWrite(VariableIDs.ServRemCurrentExpired, ++i);
	smWrite(VariableIDs.ServRemTotalExpired,totalServRemActive);

	// popup screen
	sendEvent (EventIDs.ServremShowPopUp);
}

void ServiceReminderRemoveActive(int index)
{
	int i=0;
	
	// check if already in list
	for ( i=0; i<20; i++)
	{
		if(	activeServiceReminders[i]==index )
			{
				activeServiceReminders[i]=-1;
				totalServRemActive--;
				smWrite(VariableIDs.ServRemTotalExpired,totalServRemActive);
				ShowNextServiceReminder();
				break;
			}
	}
}

void UpdateServiceReminderData (uint index)
{
	// writes data to SR popup variables
}

void ShowNextServiceReminder() 
{
	int i=0;
	int index=0;
	int offset=0;
	
	smRead(VariableIDs.ServRemCurrentExpired, offset);
	offset--;
	
	for ( i=1; i<20; i++)
	{
		index=(offset+i)%20;
		if( activeServiceReminders[index]!=-1)
		{
			offset = ( offset + 1 ) % totalServRemActive;
			smWrite(VariableIDs.ServRemPopupData,activeServiceReminders[index]);
			break;
		}
	}
	
	if( i == 20 )
	{
		offset = 0;
	}
	
	smWrite(VariableIDs.ServRemCurrentExpired, offset+1);	
}

void ShowPrevServiceReminder()
{
	int i=0;
	int index=0;
	int offset=0;
	
	smRead(VariableIDs.ServRemCurrentExpired, offset);
	offset--;
	
	for ( i=1; i<20; i++)
	{
		index=(offset+20-i)%20;
		if( activeServiceReminders[index]!=-1)
			{
				offset = ( offset + totalServRemActive - 1 ) % totalServRemActive;
				smWrite(VariableIDs.ServRemPopupData,activeServiceReminders[index]);
				break;
			}
	}
	
	if( i == 20 )
	{
		offset = 0;
	}
	
	smWrite(VariableIDs.ServRemCurrentExpired, offset+1);
	
}

//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as CheckEngineHoursServiceReminders for main script method
//---------------------------------------------------------------------------------------------
//void CheckEngineHoursServiceReminders () 
//{
//	float target, remainder, engHours;
//	int init=0;
//
//
//	smRead(HNDL_Engine_Hours, engHours);
//    
//	for ( int i = 0 ; i < 3 ; i++)
//	{
//		smRead(HNDL_ServRem_Init[ServRem_IDs[i]-1], init);
//		
//		if (init==1)
//		{
//			smRead(HNDL_ServRem_Hours_Target[i], target);
//			remainder = target - engHours;
//			smWrite(HNDL_ServRem_Hours_Remainder[i], remainder);
//					
//			if (engHours > target)
//			{
//				ServiceReminderExpired( ServRem_IDs[i] );
//			}
//			else
//			{
//				ServiceReminderRemoveActive( ServRem_IDs[i] );
//			}
//		}
//	}
//}

//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as CheckDaysServiceReminders for main script method
//---------------------------------------------------------------------------------------------
void CheckDaysServiceReminders () 
{
 	float target, remainder, currentDay=0;
	int init=0;
	
	smRead(HNDL_ServRem_CurrentDate, currentDay);
    
	for ( int i = 0 ; i < 20 ; i++)
	{
		smRead(HNDL_ServRem_Init[ServRem_Days_IDs[i]-1], init);

		if (init==1)
		{
			smRead(HNDL_ServRem_Days_Target[i], target);
			remainder = target - currentDay;
			smWrite(HNDL_ServRem_Days_Remainder[i], remainder);
					
			if (currentDay > target)
			{
				ServiceReminderExpired(ServRem_Days_IDs[i]);
			}
			else
			{
				ServiceReminderRemoveActive( ServRem_Days_IDs[i] );
			}
		}
		
	}  
}

//-----ScriptName=Globals
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Globals for main script method
//---------------------------------------------------------------------------------------------
void Globals () 
{
    
}

// Temperature sender table
uint[][] es2t = {
	{  0,210}, // tolerance
	{  52,150},
	{  62,150},
	{ 124,120},
	{ 200,100},
	{ 329,80},
	{ 518,60},
	{ 740,40},
	{ 750,40},
	{ 1023,0}, // tolerance
}; // raw, celsius
uint es2t_points = 10;

// linear interpolation fuction
float lerp(int xa, int ya, int xb, int yb, int x)
{
	float y;
	
	y = ya + ( yb - ya ) * ( x - xa ) / ( xb - xa );
	
	return y;
}

//-----ScriptName=Calculate Hydraulic Temp
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Calculate_Hydraulic_Temp for main script method
//---------------------------------------------------------------------------------------------
void Calculate_Hydraulic_Temp () 
{
	// Read the unit location (front/back)
	uint unitLocation = 0;	
	smRead(VariableIDs.Unit_Location, unitLocation);	

	// If unit is installed in back, the value will be received on the CAN bus. 
	// There is no need to calculate anything. Just return.
	if (unitLocation == VariableEnumerations.Unit_Location_Back)
		return;
	
	// Read the raw ADC value from the analog input variable
	uint raw = 0;
	if (smRead(VariableIDs.IO_Hydraulic_Tempurature, raw) == false)
		return; // Read failed, return
	
	// Convert the raw ADC value it to a temperature (Celsius) using the linear interpolation function.
	// Write the value to the Any variable (for display) as well as the Transmit 
	// variable (for transmission on the CAN bus).
	int hydraulicTemperature = 0;
	if (raw >= 30 && raw <= 1000)
	{
		// Use lookup table to find which bracket/tier the raw ADC value is in.
		// Then use linear interpolation function to get calculated value.
		for (uint i = 0; i < (es2t_points - 1); ++i) 
			if ((raw >= es2t[i][0]) && (raw <= es2t[i+1][0]))
			{
				hydraulicTemperature = lerp(es2t[i][0], es2t[i][1], es2t[i+1][0], es2t[i+1][1], raw);
				break;
			}
	}
	else // Raw ADC value is out of bounds. Write 0.
		hydraulicTemperature = 0;
	
	// Write the value to the database variables
	smWrite(VariableIDs.J1939_Transmit_Hydraulic_Temperature, hydraulicTemperature);
	smWrite(VariableIDs.J1939_Front_Display_Hydraulic_Temperature, hydraulicTemperature);	
}

//-----ScriptName=SC_Access.Code
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as SC_Access_Code_Update for main script method
//---------------------------------------------------------------------------------------------
const string codeKey = "8503";

int codeValA = VariableIDs.Access_CodeA;
int codeValB = VariableIDs.Access_CodeB;
int codeValC = VariableIDs.Access_CodeC;
int codeValD = VariableIDs.Access_CodeD;

//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as SC_Access_Code_PageInit for main script method
//---------------------------------------------------------------------------------------------
void SC_Access_Code_PageInit () 
{
   cultureSetString(StringIDs.Access_CodeInvalidTxt," ",true); 
   cultureSetString(StringIDs.AccessCode," ",true); 
}

void resetAccessCode ()
{
	//Reset Code fields
	smWrite(codeValA,0);
	smWrite(codeValB,0);
	smWrite(codeValC,0);
	smWrite(codeValD,0);
}

void SC_Access_Code_Reset () 
{
	resetAccessCode();
}

void SC_Access_Code_Update () 
{
    int A = 0;
	int B = 0;
	int C = 0;
	int D = 0;
    smRead(codeValA,A);
	smRead(codeValB,B);
	smRead(codeValC,C);
	smRead(codeValD,D);
	
	string codeValABCD = A+"";
		codeValABCD += B+"";
		codeValABCD += C+"";
		codeValABCD += D+"";
	//return codeValABCD;
	
	cultureSetString(StringIDs.AccessCode,codeValABCD,true);
}

void SC_Access_Code_Check () 
{
    string codeString;
	cultureGetString(StringIDs.AccessCode,codeString,0);
	if(codeString == codeKey)
	{
		//navigate to dealer settings page
		sendEvent(EventIDs.TR_Access_Code_Success);
		//Reset Code fields
//		resetDealerCode ();
		//hide invalid txt
		//screenApiHide(ScreenObjectIDs.TW_DealerCode_Invalid);
		cultureSetString(StringIDs.Access_CodeInvalidTxt,"Success",true);
	}
	else
	{
		//Reset Code fields
		resetAccessCode ();
		//show invalid txt
		//screenApiShow(ScreenObjectIDs.TW_DealerCode_Invalid);
		cultureSetString(StringIDs.Access_CodeInvalidTxt,"You have entered an invalid code",true);
	}
}

//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as SC_Access_Code_Inc for main script method
//---------------------------------------------------------------------------------------------
void SC_Access_Code_Inc () 
{
    int i;
    smRead(VariableIDs.Access_CodeInput_Selected,i);
	
	if(i == 0)
	{
		sendEvent(EventIDs.DB_Access_CodeA_Inc);
	}
	else if(i == 1)
	{
		sendEvent(EventIDs.DB_Access_CodeB_Inc);
	}
	else if(i == 2)
	{
		sendEvent(EventIDs.DB_Access_CodeC_Inc);
	}
	else if(i == 3)
	{
		sendEvent(EventIDs.DB_Access_CodeD_Inc);
	}
}

//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as SC_Access_Code_Dec for main script method
//---------------------------------------------------------------------------------------------
void SC_Access_Code_Dec () 
{
    int i;
    smRead(VariableIDs.Access_CodeInput_Selected,i);
	
	if(i == 0)
	{
		sendEvent(EventIDs.DB_Access_CodeA_Dec);
	}
	else if(i == 1)
	{
		sendEvent(EventIDs.DB_Access_CodeB_Dec);
	}
	else if(i == 2)
	{
		sendEvent(EventIDs.DB_Access_CodeC_Dec);
	}
	else if(i == 3)
	{
		sendEvent(EventIDs.DB_Access_CodeD_Dec);
	}
}

//-----ScriptName=SCR DM1 Faults
uint DM1FaultCount = 0;
uint DM1ListPointer = 0;

uint NumberOfPossible = 47;
uint [] DM1Active(NumberOfPossible);
uint [] DM1List(NumberOfPossible);
string [] DM1Correction(NumberOfPossible);

void SCE_DM1_Faults ()
{	uint Pointer1 = 0;
	uint Pointer2 = 0;
	uint CurrentFault = 0;
	DM1FaultCount = 0;
    uint DM1Enable;
	smRead(VariableIDs.VAR_Disable_DM1,DM1Enable);
	if (DM1Enable == 0)
	{
	while(Pointer1 < NumberOfPossible)
	{	smRead(Faults[Pointer1],CurrentFault);
		if(CurrentFault != 0 || DM1Active[Pointer1] == 1)
		{	if(FaultType[Pointer1] == 0 && CurrentFault < 3)
			{	DM1Correction[Pointer2] = Correction[CurrentFault];
				DM1FaultCount ++;
				DM1List[Pointer2] = Pointer1;
				Pointer2 ++;
			}
			if(FaultType[Pointer1] == 1 && CurrentFault < 2)
			{	DM1Correction[Pointer2] = Correction[CurrentFault + 4];
				DM1FaultCount ++;
				DM1List[Pointer2] = Pointer1;
				Pointer2 ++;
			}
			if(FaultType[Pointer1] == 2 && CurrentFault < 9)
			{	DM1Correction[Pointer2] = Correction[CurrentFault + 8];
				DM1FaultCount ++;
				DM1List[Pointer2] = Pointer1;
				Pointer2 ++;
			}
			if(FaultType[Pointer1] == 3 && CurrentFault < 3)
			{	DM1Correction[Pointer2] = Correction[CurrentFault + 24];
				DM1FaultCount ++;
				DM1List[Pointer2] = Pointer1;
				Pointer2 ++;
			}
			if(FaultType[Pointer1] == 4 && CurrentFault < 2)
			{	DM1Correction[Pointer2] = Correction[CurrentFault + 28];
				DM1FaultCount ++;
				DM1List[Pointer2] = Pointer1;
				Pointer2 ++;
			}
			if(DM1Active[Pointer1] == 0)
			{	DM1Active[Pointer1] = 1;
				sendEvent(EventIDs.UE_Show_DM1);
				DM1ListPointer = 0;
			}
		}
		else
		{	DM1Active[Pointer1] = 0;
		}
		Pointer1 ++;
	}
	if(DM1FaultCount == 0)
	{	sendEvent(EventIDs.UE_Close_DM1_Popup);
	}
	smWrite(VariableIDs.VAR_DM1FaultCount,DM1FaultCount);
	sendEvent(EventIDs.SCE_DM1_List);
}
}
void SCE_DM1_List ()
{	uint Pointer;
	if(DM1FaultCount == 0)
	{	cultureSetString(StringIDs.STR_DM1_CurrentSource,"NO FAULTS AVAILABLE",true);
		cultureSetString(StringIDs.STR_DM1_CurrentDescription,"",true);
		cultureSetString(StringIDs.STR_DM1_CurrentCorrection,"",true);
		smWrite(VariableIDs.VAR_DM1CurrentFault,0);
		DM1ListPointer = 0;
	}
	else
	{	if(DM1ListPointer >= DM1FaultCount)
		{	DM1ListPointer = 0;
		}
		Pointer = DM1List[DM1ListPointer];
		smWrite(VariableIDs.VAR_DM1CurrentAck,DM1Active[Pointer]);
		smWrite(VariableIDs.VAR_DM1CurrentFault,DM1ListPointer+1);
		cultureSetString(StringIDs.STR_DM1_CurrentSource,Source[Pointer],true);
		cultureSetString(StringIDs.STR_DM1_CurrentDescription ,DM1Descr[Pointer],true);
		cultureSetString(StringIDs.STR_DM1_CurrentCorrection,DM1Correction[DM1ListPointer],true);
	}
}
void SCE_Next_DM1 () 
{	if(DM1ListPointer < DM1FaultCount - 1)
	{	DM1ListPointer ++;
	}
	else
	{	DM1ListPointer = DM1FaultCount - 1;
	}
	sendEvent(EventIDs.SCE_DM1_List);
}
void SCE_Prev_DM1 ()
{	if(DM1ListPointer > 0)
	{	DM1ListPointer --;
	}
	else
	{	DM1ListPointer = 0;
	}
	sendEvent(EventIDs.SCE_DM1_List);
}
void SCE_DM1_Acknowledge_All ()
{	DM1ListPointer = 0;
	uint Pointer;
	while(DM1ListPointer < DM1FaultCount)
	{	Pointer = DM1List[DM1ListPointer];
		DM1Active[Pointer] = 2;
		DM1ListPointer++;
	}
	sendEvent(EventIDs.UE_Hide_DM1_Popup);
}
void SCE_DM1_Recall ()
{	DM1ListPointer = 0;
	sendEvent(EventIDs.SCE_DM1_List);
	sendEvent(EventIDs.UE_Show_DM1);
}

//-----ScriptName=SCR Arrays_Faults
uint [] Faults = {	
//	VariableIDs.FFC_R260_Master_IO_01,
//	VariableIDs.FFC_R260_Master_IO_02,
//	VariableIDs.FFC_R260_Master_IO_03,
//	VariableIDs.FFC_R260_Master_IO_04,
//	VariableIDs.FFC_R260_Master_IO_05,
//	VariableIDs.FFC_R260_Master_IO_06,
//	VariableIDs.FFC_R260_Master_IO_09,
//	VariableIDs.FFC_R260_Master_IO_10,
//	VariableIDs.FFC_R260_Master_IO_11,
//	VariableIDs.FFC_R260_Master_IO_12,
//	VariableIDs.FFC_R260_Master_IO_13,
//	VariableIDs.FFC_R260_Master_IO_14,
//	VariableIDs.FFC_R260_Master_IO_15,
//	VariableIDs.FFC_R260_Master_IO_16,
//	VariableIDs.FFC_R260_Master_IO_V,
	VariableIDs.FFC_mVEC1_Relay_01,
	VariableIDs.FFC_mVEC1_Relay_02,
	VariableIDs.FFC_mVEC1_Relay_03,
	VariableIDs.FFC_mVEC1_Relay_04,
	VariableIDs.FFC_mVEC1_Relay_05,
	VariableIDs.FFC_mVEC1_Relay_06,
	VariableIDs.FFC_mVEC1_Relay_07,
	VariableIDs.FFC_mVEC1_Fuse_01,
	VariableIDs.FFC_mVEC1_Fuse_02,
	VariableIDs.FFC_mVEC1_Fuse_03,//10
	VariableIDs.FFC_mVEC1_Fuse_04,
	VariableIDs.FFC_mVEC1_Fuse_06,
	VariableIDs.FFC_mVEC1_Fuse_07,
	VariableIDs.FFC_mVEC1_Fuse_08,
	VariableIDs.FFC_mVEC1_Communication,
	VariableIDs.FFC_mVEC2_Relay_01,
	VariableIDs.FFC_mVEC2_Relay_02,
	VariableIDs.FFC_mVEC2_Relay_03,
	VariableIDs.FFC_mVEC2_Relay_04,
	VariableIDs.FFC_mVEC2_Relay_05,//20
	VariableIDs.FFC_mVEC2_Relay_06,
	VariableIDs.FFC_mVEC2_Relay_07,
	VariableIDs.FFC_mVEC2_Relay_08,
	VariableIDs.FFC_mVEC2_Fuse_01,
	VariableIDs.FFC_mVEC2_Fuse_02,
	VariableIDs.FFC_mVEC2_Fuse_03,
	VariableIDs.FFC_mVEC2_Fuse_04,
	VariableIDs.FFC_mVEC2_Fuse_05,
	VariableIDs.FFC_mVEC2_Fuse_06,
	VariableIDs.FFC_mVEC2_Fuse_07,//30
	VariableIDs.FFC_mVEC2_Fuse_08,
	VariableIDs.FFC_mVEC2_Communication,
	VariableIDs.FFC_mVEC3_Relay_01,
	VariableIDs.FFC_mVEC3_Relay_02,
	VariableIDs.FFC_mVEC3_Relay_03,
	VariableIDs.FFC_mVEC3_Relay_04,
	VariableIDs.FFC_mVEC3_Relay_05,
	VariableIDs.FFC_mVEC3_Relay_06,
	VariableIDs.FFC_mVEC3_Relay_07,
	VariableIDs.FFC_mVEC3_Fuse_01,//40
	VariableIDs.FFC_mVEC3_Fuse_02,
	VariableIDs.FFC_mVEC3_Fuse_03,
	VariableIDs.FFC_mVEC3_Fuse_04,
	VariableIDs.FFC_mVEC3_Fuse_06,
	VariableIDs.FFC_mVEC3_Fuse_07,
	VariableIDs.FFC_mVEC3_Fuse_08,
	VariableIDs.FFC_mVEC3_Communication};//47

string [] DM1Descr = {	
//	"LIFT IN (OUTPUT 1)",
//	"LIFT OUT (OUTPUT 2)",
//	"TILT UP (OUTPUT 3)",
//	"TILT DOWN (OUTPUT 4)",
//	"BOOM UP (OUTPUT 5)",
//	"BOOM DOWN (OUTPUT 6)",
//	"FOLD UP (OUTPUT 9)",
//	"FOLD DOWN (OUTPUT 10)",
//	"LEFT WINCH IN (OUTPUT 11)",
//	"LEFT WINCH OUT (OUTPUT 12)",
//	"RIGHT WINCH IN (OUTPUT 13)",
//	"RIGHT WINCH OUT (OUTPUT 14)",
//	"BOOM OUT (OUTPUT 15)",
//	"BOOM IN (OUTPUT 16)",
//	"SUPPLY VOLTAGE",
	"RELAY 1 (PASSENGER DOCK)",
	"RELAY 2 (RIGHT TURN)",
	"RELAY 3 (BRAKE)",
	"RELAY 4 (REVERSE)",
	"RELAY 5 (UNDERLIFT LIGHTS)",
	"RELAY 6 (IGNITION OUT)",
	"RELAY 7 (PTO)",
	"FUSE 1 (PASSENGER DOCK)",
	"FUSE 2 (REVERSE)",
	"FUSE 3 (PTO)",
	"FUSE 4 (RIGHT TURN)",
	"FUSE 6 (IGNITION OUT)",
	"FUSE 7 (BRAKE)",
	"FUSE 8 (UNDERLIFT LIGHTS)",
	"COMMUNICATION",
	"RELAY 1 (MARKERS)",
	"RELAY 2 (UPPER LIGHTS)",
	"RELAY 3 (MAIN BEACON)",
	"RELAY 4 (AUX BEACON)",
	"RELAY 5 (WORK UP LIGHTS)",
	"RELAY 6 (CONTROLS POWER)",
	"RELAY 7 (MARKER FLASHERS)",
	"RELAY 8 (TOOLBOX LIGHTS)",
	"FUSE 1 (MARKERS)",
	"FUSE 2 (AUX BEACON)",
	"FUSE 3 (MARKER FLASHERS)",
	"FUSE 4 (UPPER LIGHTS)",
	"FUSE 5 (TOOLBOX LIGHTS)",
	"FUSE 6 (CONTROLS POWER)",
	"FUSE 7 (MAIN BEACON)",
	"FUSE 8 (WORK UP LIGHTS)",
	"COMMUNICATION",
	"RELAY 1 (TAIL LIGHTS)",
	"RELAY 2 (BOOM LIGHTS)",
	"RELAY 3 (DRIVERS DOCK)",
	"RELAY 4 (SWIVEL LIGHTS)",
	"RELAY 5 (LEFT TURN)",
	"RELAY 6 (AUX 1)",
	"RELAY 7 (AUX 2)",
	"FUSE 1 (TAIL LIGHTS)",
	"FUSE 2 (SWIVEL LIGHTS)",
	"FUSE 3 (AUX 2)",
	"FUSE 4 (BOOM LIGHTS)",
	"FUSE 6 (AUX 1)",
	"FUSE 7 (DRIVERS DOCK)",
	"FUSE 8 (LEFT TURN)",
	"COMMUNICATION"};

string [] Source = {	
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
//	"R260 Master",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 1",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 2",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3",
	"mVEC 3"};

uint [] FaultType = {	
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	0,
//	1,
	2,
	2,
	2,
	2,
	2,
	2,
	2,
	3,
	3,
	3,
	3,
	3,
	3,
	3,
	4,
	2,
	2,
	2,
	2,
	2,
	2,
	2,
	2,
	3,
	3,
	3,
	3,
	3,
	3,
	3,
	3,
	4,
	2,
	2,
	2,
	2,
	2,
	2,
	2,
	3,
	3,
	3,
	3,
	3,
	3,
	3,
	4};

string [] Correction = {	
	"NO FAULT",
	"SHORT TO GROUND",
	"SHORT TO BATTERY",
	"RESERVED",
	"NORMAL",
	"LOW, < 8V",
	"RESERVED",
	"RESERVED",
	"NO FAULT",
	"RELAY COIL OPEN OR RELAY NOT PRESENT",
	"COIL SHORTED OR FAILED RELAY DRIVER",
	"NORMALLY OPEN (N.O.) CONTACT IS OPEN",
	"NORMALLY CLOSED (N.C.) CONTACT IS OPEN",
	"COIL NOT RECEIVING POWER",
	"NORMALLY OPEN (N.O.) CONTACT IS SHORTED",
	"NORMALLY CLOSED (N.C.) CONTACT IS SHORTED",
	"GROUND IS NOT EQUAL TO 0V",
	"RESERVED",
	"RESERVED",
	"RESERVED",
	"RESERVED",
	"RESERVED",
	"RESERVED",
	"RESERVED",
	"NO FAULT",
	"BLOWN",
	"NOT POWERED",
	"UNUSED",
	"NO ERROR",
	"COMMUNICATION ERROR",
	"RESERVED",
	"UNUSED"};


//-----ScriptName=PTO & T110 Cradle Warning
bool ptoWarningActive = false;
bool t110WarningLockoutExpired = false;
bool t110WarningActive = false;

void Test_for_PTO_Warning ()
{
	uint pto, t110;
	if (smRead(VariableIDs.J1939_MVEC_PTO__in_, pto) && smRead(VariableIDs.J1939_MVEC_Charge_Cradle_Warning, t110))
	{
		// Value went from 0->1 or 1->0. Either way a running timer needs to be canceled
		SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Cancel_Timer, TimerIDs.TimerVariable_PtoWarningLockout);
		
		// Start lockout timer if value is 1. Otherwise clear the active flag.
		if (pto == 0)
			ptoWarningActive = false;
		else if (pto == 1)
			SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Start_Timer, TimerIDs.TimerVariable_PtoWarningLockout);
		
		// If PTO was disengaged and the T110 lockout has expired, show the T110 warning
		if (pto == 0 && t110WarningLockoutExpired == true)
			t110WarningActive = true;
			
		// Update the UI
		UpdatePtoT110WarningUI();
	}
}

void CheckPtoWarning()
{
	uint pto;
	if (smRead(VariableIDs.J1939_MVEC_PTO__in_, pto))
	{
		// Warning is active if value is 1 because the timer has expired
		ptoWarningActive = (pto == 1);	
				
		// Update the UI
		UpdatePtoT110WarningUI();	
	}
}

void PtoWarningLockoutExpired () 
{
    CheckPtoWarning();
}

void PtoWarningHide () 
{
	// Restart the timer and clear the active flag
	SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Cancel_Timer, TimerIDs.TimerVariable_PtoWarningHide);
    SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Start_Timer, TimerIDs.TimerVariable_PtoWarningHide);
	ptoWarningActive = false;
	
	// Update the UI
	UpdatePtoT110WarningUI();
}

void PtoWarningHideExpired () 
{
	CheckPtoWarning();
}

void J1939_MVEC_Charge_Cradle_Warning_Changed ()
{
	uint pto, t110;
	if (smRead(VariableIDs.J1939_MVEC_PTO__in_, pto) && smRead(VariableIDs.J1939_MVEC_Charge_Cradle_Warning, t110))
	{
		// Value went from 0->1 or 1->0. Either way a running timer needs to be canceled
		SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Cancel_Timer, TimerIDs.TimerVariable_T110WarningLockout);
		
		// Start lockout timer if value is 1. If value is 0 or PTO is engaged clear the active flag.
		if (t110 == 0 || pto == 1)
			t110WarningActive = t110WarningLockoutExpired = false;
		else if (t110 == 1)
			SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Start_Timer, TimerIDs.TimerVariable_T110WarningLockout);
		
		// Update the UI
		UpdatePtoT110WarningUI();
	}
}

void CheckT110Warning()
{
	uint pto, t110;
	if (smRead(VariableIDs.J1939_MVEC_PTO__in_, pto) && smRead(VariableIDs.J1939_MVEC_Charge_Cradle_Warning, t110))
	{
		// Warning is active if value is 1 because the timer has expired
		t110WarningActive = (pto == 0 && t110 == 1);	
				
		// Update the UI
		UpdatePtoT110WarningUI();	
	}
}

void T110WarningLockoutExpired () 
{
	t110WarningLockoutExpired = true;
	CheckT110Warning();
}

void T110WarningHide () 
{
    // Restart the timer and clear the active flag
	SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Cancel_Timer, TimerIDs.TimerVariable_T110WarningHide);
    SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Start_Timer, TimerIDs.TimerVariable_T110WarningHide);
	t110WarningActive = false;
	
	// Update the UI
	UpdatePtoT110WarningUI();
}

void T110WarningHideExpired () 
{
    CheckT110Warning();
}

void UpdatePtoT110WarningUI()
{
	// Show warning popups for front display only
	if (UnitLocationSelected() == false || IsFrontDisplay() == false)
		return;
	
	if (ptoWarningActive == true)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Overlay_Layer_MVEC_Warning_PTO_);
		sendEvent(EventIDs.Calculate_VideoSize_Overlay_ON);
	}
	else if (t110WarningActive == true)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Overlay_Layer_MVEC_Warning_T110_Not_in_charge_cradle);
		sendEvent(EventIDs.Calculate_VideoSize_Overlay_ON);
	}
	else
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Overlay_Layer_Default_Empty_View);
		sendEvent(EventIDs.Calculate_VideoSize_Overlay_OFF);
	}
}


//-----ScriptName=Light Button
bool lightButtonOn = false;
void LightButtonPress () 
{
	// Read which switches are tied to the button
	uint aux1, aux2, auxBeacon, boomLights, driversDock, mainBeacon, markerFlashers, passengerDock, 
	     swivelLights, tailLights, toolboxLights, underliftLights, upperLights, workUpLights;
		 
	bool valid = smRead(VariableIDs.LightButton_Aux1, aux1) &&
				 smRead(VariableIDs.LightButton_Aux2, aux2) &&
				 smRead(VariableIDs.LightButton_AuxBeacon, auxBeacon) &&
				 smRead(VariableIDs.LightButton_BoomLights, boomLights) &&
				 smRead(VariableIDs.LightButton_DriversDock, driversDock) &&
				 smRead(VariableIDs.LightButton_MainBeacon, mainBeacon) &&
				 smRead(VariableIDs.LightButton_MarkerFlashers, markerFlashers) &&
				 smRead(VariableIDs.LightButton_PassengerDock, passengerDock) &&
				 smRead(VariableIDs.LightButton_SwivelLights, swivelLights) &&
				 smRead(VariableIDs.LightButton_TailLights, tailLights) &&
				 smRead(VariableIDs.LightButton_ToolboxLights, toolboxLights) &&
				 smRead(VariableIDs.LightButton_UnderliftLights, underliftLights) &&
				 smRead(VariableIDs.LightButton_UpperLights, upperLights) &&
				 smRead(VariableIDs.LightButton_WorkUpLights, workUpLights);
 

	// Set the control bits for the switches and send the control messages
	if (valid == true)
	{
		// Toggle button
		lightButtonOn = !lightButtonOn;
	
		if (passengerDock == 1)
			smWrite(VariableIDs.J1939_Transmit_PassengerDock__out_ , lightButtonOn ? 1 : 0);
			
		if (underliftLights == 1)
			smWrite(VariableIDs.J1939_Transmit_UnderliftLights__out_, lightButtonOn ? 1 : 0);
		
		if (upperLights == 1)
			smWrite(VariableIDs.J1939_Transmit_UpperLights__out_, lightButtonOn ? 1 : 0);
		
		if (mainBeacon == 1)
			smWrite(VariableIDs.J1939_Transmit_MainBeacon__out_, lightButtonOn ? 1 : 0);
		
		if (auxBeacon == 1)
			smWrite(VariableIDs.J1939_Transmit_AuxBeacon__out_, lightButtonOn ? 1 : 0);
		
		if (workUpLights == 1)
			smWrite(VariableIDs.J1939_Transmit_WorkupLights__out_, lightButtonOn ? 1 : 0);
		
		if (markerFlashers == 1)
			smWrite(VariableIDs.J1939_Transmit_MarkerFlashers__out_, lightButtonOn ? 1 : 0);
		
		if (toolboxLights == 1)
			smWrite(VariableIDs.J1939_Transmit_ToolboxLights__out_, lightButtonOn ? 1 : 0);
		
		if (tailLights == 1)
			smWrite(VariableIDs.J1939_Transmit_TailLights__out_, lightButtonOn ? 1 : 0);
		
		if (boomLights == 1)
			smWrite(VariableIDs.J1939_Transmit_BoomLights__out_, lightButtonOn ? 1 : 0);
		
		if (driversDock == 1)
			smWrite(VariableIDs.J1939_Transmit_DriversDock__out_, lightButtonOn ? 1 : 0);
		
		if (swivelLights == 1)
			smWrite(VariableIDs.J1939_Transmit_SwivelLights__out_, lightButtonOn ? 1 : 0);
		
		if (aux1 == 1)
			smWrite(VariableIDs.J1939_Transmit_Aux1__out_, lightButtonOn ? 1 : 0);
		
		if (aux2 == 1)
			smWrite(VariableIDs.J1939_Transmit_Aux2__out_, lightButtonOn ? 1 : 0);
	}
}

//-----ScriptName=BoomFillTruckName
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as BoomMinusFillTruckName for main script method
//---------------------------------------------------------------------------------------------
void BoomMinusFillTruckName () 
{
	int TruckTp;
    if(smRead(VariableIDs.BoomTruckType,TruckTp))
	{
		if((TruckTp < 1  ) || (TruckTp > 16)){
			cultureSetString(StringIDs.STR_BoomTruckName, " ", true);	
		}else if(TruckTp == 1){
			cultureSetString(StringIDs.STR_BoomTruckName, "1140-4x3", true); //20161207 - Swapped 1140-RXP & 1140-4x3
		}else if(TruckTp == 2){
			cultureSetString(StringIDs.STR_BoomTruckName, "1140-RXP", true); //20161207 - Swapped 1140-RXP & 1140-4x3
		}else if(TruckTp == 3){
			cultureSetString(StringIDs.STR_BoomTruckName, "1060-4x3", true);
		}else if(TruckTp == 4){
			cultureSetString(StringIDs.STR_BoomTruckName, "1075-4x3", true);
		}else if(TruckTp == 5){
			cultureSetString(StringIDs.STR_BoomTruckName, "1075-H", true);
		}else if(TruckTp == 6){
			cultureSetString(StringIDs.STR_BoomTruckName, "1130", true);
		}else if(TruckTp == 7){
			cultureSetString(StringIDs.STR_BoomTruckName, "9055", true);
		}else if(TruckTp == 8){
			cultureSetString(StringIDs.STR_BoomTruckName, "1150S-H", true);
		}else if(TruckTp == 9){
			cultureSetString(StringIDs.STR_BoomTruckName, "1150S-4x3", true);
		}else if(TruckTp == 10){
			cultureSetString(StringIDs.STR_BoomTruckName, "1150S-RXP", true);
		}else if(TruckTp == 11){
			cultureSetString(StringIDs.STR_BoomTruckName, "1150R-H", true);
		}else if(TruckTp == 12){
			cultureSetString(StringIDs.STR_BoomTruckName, "1150R-4x3", true);
		}else if(TruckTp == 13){
			cultureSetString(StringIDs.STR_BoomTruckName, "1150R-RXP", true);
		}else if(TruckTp == 14){
			cultureSetString(StringIDs.STR_BoomTruckName, "1075S2", true); //4x3
		}else if(TruckTp == 15){
			cultureSetString(StringIDs.STR_BoomTruckName, "1060-H", true);
		}else if(TruckTp == 16){
			cultureSetString(StringIDs.STR_BoomTruckName, "1135", true);
		}
	}
}

//-----ScriptName=Lightbar Transmit
void LightbarSetState(LightbarEnum lightbar, LightbarInputEnum input, LightbarStateEnum state, bool transmit)
{
	// Check bounds
	if (((lightbar >= eLightbar1 && lightbar < eLightbarCount) == false) ||
		((input >= eLightbarInput01 && input < eLightbarInputCount) == false) ||
		((state >= eLightbarStateOff && state < eLightbarStateCount) == false))
		return;

	// Write variable and set requested value (for retry logic)	
	smWrite(LightbarControlBits[lightbar][input], state);
	LightbarRequestedValue[lightbar][input] = state;
	
	if (transmit)
	{
		// Send CAN message and restart retry timer
		LightbarTx(lightbar);
		SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Cancel_Timer, LightbarRetryTimer[lightbar]);
		SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Start_Timer, LightbarRetryTimer[lightbar]);
	}
}

void LightbarTx(LightbarEnum lightbar)
{
	// Read control bit values into 64-bit variable for easy processing
	uint[] values(eLightbarInputCount);
	uint64 data = 0;
	for (uint i = 0; i < values.length(); ++i)
	{
		smRead(LightbarControlBits[lightbar][i], values[i]);
		data |= uint64((values[i] & 7)) << (3*i);
	}
	
	// Define message type
	CANMessageInfo info;
    info.MessageType = CANMessageInfoType.SinglePacket; // Use display source address
    
	// Create message buffer, set ID, and write control bits to the message data
    CANMessageBuffer message;
    message.CanID = 0x18000000 | (LightbarControlPgn[lightbar] << 8);
    message.Size = 8;
	for (uint i = 0; i < message.Size; ++i)
		message.WriteInt8(i, (data >> (8*i)) & 0xFF);

	// Front display sends control message on CAN1
	// Back display sends control message on CAN2
	// Lightbars are on CAN2
	if (UnitLocationSelected() == true)
	{
		if (IsFrontDisplay() == true)
			SendCANMessage(0, message, info);
		else
			SendCANMessage(1, message, info);
	}
}

void Lightbar1_Retry () { LightbarRetry(eLightbar1); }
void Lightbar2_Retry () { LightbarRetry(eLightbar2); }
void Lightbar3_Retry () { LightbarRetry(eLightbar3); }
void Lightbar4_Retry () { LightbarRetry(eLightbar4); }

void LightbarRetry(LightbarEnum lightbar)
{
	SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Cancel_Timer, LightbarRetryTimer[lightbar]);
	LightbarTx(lightbar);
	SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Start_Timer, LightbarRetryTimer[lightbar]);
}

void Lightbar_MainBeaconToggle ()
{
	int value, rotator;
	if (smRead(LightbarControlBits[eLightbar1][eLightbarInput01], value) && smRead(VariableIDs.Rotator_Enabled, rotator))
	{
		if (value == eLightbarStateOff)
			LightbarMainBeaconOn(rotator);
		else
			LightbarMainBeaconOff(rotator);
	}
}

void Lightbar_MainBeaconON ()
{
	int rotator;
	
	if (smRead(VariableIDs.Rotator_Enabled, rotator))
	{
		LightbarMainBeaconOn(rotator);
	}
}

void Lightbar_MainBeaconOFF ()
{
	int rotator;
	
	if (smRead(VariableIDs.Rotator_Enabled, rotator))
	{
		LightbarMainBeaconOff(rotator);
	}
}

void LightbarMainBeaconOn(uint rotator) 
{
	if (rotator == VariableEnumerations.Rotator_Enabled_Rotator)
	{
    	LightbarSetState(eLightbar1, eLightbarInput01, eLightbarState1, false);
		LightbarSetState(eLightbar1, eLightbarInput04, eLightbarState1, true);
	}
	else if (rotator == VariableEnumerations.Rotator_Enabled_Integrated)
	{
		LightbarSetState(eLightbar1, eLightbarInput01, eLightbarState1, false);
		LightbarSetState(eLightbar1, eLightbarInput04, eLightbarState1, true);
		LightbarSetState(eLightbar4, eLightbarInput01, eLightbarState1, false);
		LightbarSetState(eLightbar4, eLightbarInput04, eLightbarState1, true);
	}
}

void LightbarMainBeaconOff(uint rotator) 
{
	if (rotator == VariableEnumerations.Rotator_Enabled_Rotator)
	{
    	LightbarSetState(eLightbar1, eLightbarInput01, eLightbarStateOff, false);
		LightbarSetState(eLightbar1, eLightbarInput04, eLightbarStateOff, true);
	}
	else if (rotator == VariableEnumerations.Rotator_Enabled_Integrated)
	{
		LightbarSetState(eLightbar1, eLightbarInput01, eLightbarStateOff, false);
		LightbarSetState(eLightbar1, eLightbarInput04, eLightbarStateOff, true);
		LightbarSetState(eLightbar4, eLightbarInput01, eLightbarStateOff, false);
		LightbarSetState(eLightbar4, eLightbarInput04, eLightbarStateOff, true);
	}
}

void Lightbar_AuxBeaconToggle () 
{
	int value, rotator;
	if (smRead(LightbarControlBits[eLightbar3][eLightbarInput01], value) && smRead(VariableIDs.Rotator_Enabled, rotator))
	{
		if (value == eLightbarStateOff)
			LightbarAuxBeaconOn(rotator);
		else
			LightbarAuxBeaconOff(rotator);
	}
}

void Lightbar_AuxBeaconON ()
{
	int rotator;
	if(smRead(VariableIDs.Rotator_Enabled, rotator))
	{
		LightbarAuxBeaconOn(rotator);
	}
}

void Lightbar_AuxBeaconOFF ()
{
	int rotator;
	if (smRead(VariableIDs.Rotator_Enabled, rotator))
	{
		LightbarAuxBeaconOff(rotator);
	}
}

void LightbarAuxBeaconOn(uint rotator) 
{
	if (rotator == VariableEnumerations.Rotator_Enabled_Rotator)
	{
    	LightbarSetState(eLightbar3, eLightbarInput01, eLightbarState1, false);
		LightbarSetState(eLightbar3, eLightbarInput04, eLightbarState1, true);
		LightbarSetState(eLightbar4, eLightbarInput01, eLightbarState1, false);
		LightbarSetState(eLightbar4, eLightbarInput04, eLightbarState1, true);
	}
}

void LightbarAuxBeaconOff(uint rotator) 
{
	if (rotator == VariableEnumerations.Rotator_Enabled_Rotator)
	{
    	LightbarSetState(eLightbar3, eLightbarInput01, eLightbarStateOff, false);
		LightbarSetState(eLightbar3, eLightbarInput04, eLightbarStateOff, true);
		LightbarSetState(eLightbar4, eLightbarInput01, eLightbarStateOff, false);
		LightbarSetState(eLightbar4, eLightbarInput04, eLightbarStateOff, true);
	}
}

void Lightbar_Aux1Toggle () 
{
    int value;
	if (smRead(LightbarControlBits[eLightbar1][eLightbarInput10], value))
	{
		if (value == eLightbarStateOff)
			LightbarAux1On();
		else
			LightbarAux1Off();
	}
}

void LightbarAux1On() 
{
    LightbarSetState(eLightbar1, eLightbarInput10, eLightbarState1, true);
	LightbarSetState(eLightbar3, eLightbarInput10, eLightbarState1, true);
	LightbarSetState(eLightbar4, eLightbarInput10, eLightbarState1, true);
}

void LightbarAux1Off() 
{
    LightbarSetState(eLightbar1, eLightbarInput10, eLightbarStateOff, true);
	LightbarSetState(eLightbar3, eLightbarInput10, eLightbarStateOff, true);
	LightbarSetState(eLightbar4, eLightbarInput10, eLightbarStateOff, true);
}

void Lightbar_MarkerFlashersToggle () 
{
    if (MarkerFlashersActive() == true)
		LightbarMarkerFlashersOff();
	else
		LightbarMarkerFlashersOn();
}

void LightbarMarkerFlashersOn() 
{
	LightbarSetState(eLightbar1, eLightbarInput07, eLightbarState5, true);
	LightbarSetState(eLightbar3, eLightbarInput07, eLightbarState5, true);
	LightbarSetState(eLightbar4, eLightbarInput07, eLightbarState5, true);
}

void LightbarMarkerFlashersOff() 
{
    LightbarStateEnum state = eLightbarStateOff;
	
	// Let the chassis lighting command determine status
	int highBeam, lowBeam, marker;
	if ((smRead(VariableIDs.J1939_Chassis_High_Beam, highBeam) && highBeam == 1) ||
		(smRead(VariableIDs.J1939_Chassis_Low_Beam, lowBeam) && lowBeam == 1) ||
		(smRead(VariableIDs.J1939_Chassis_Marker_Light, marker) && marker == 1))
	{
		state = eLightbarState1;
	}
	
	LightbarSetState(eLightbar1, eLightbarInput07, state, true);
	LightbarSetState(eLightbar3, eLightbarInput07, state, true);
	LightbarSetState(eLightbar4, eLightbarInput07, state, true);
}

bool MarkerFlashersActive()
{
	int value;
	return (smRead(VariableIDs.J1939_MVEC_Marker_Flashers__in_, value) && value != 0);
}

void Lightbar_LeftTrafficAdvisorToggle () 
{
	int input11, input12;
	if (smRead(LightbarControlBits[eLightbar1][eLightbarInput11], input11) && smRead(LightbarControlBits[eLightbar1][eLightbarInput12], input12))
	{
		// Determine current state
		bool leftOn  = ((input11 == eLightbarState6) || (input11 == eLightbarState3));
		bool rightOn = ((input11 == eLightbarState6) || (input12 == eLightbarState3));
	
		// Toggle left traffic advisor
		leftOn = !leftOn;
		
		// Set lightbar inputs
		LightbarSetTrafficAdvisor(leftOn, rightOn);
	}
}

void Lightbar_RightTrafficAdvisorToggle () 
{
	int input11, input12;
	if (smRead(LightbarControlBits[eLightbar1][eLightbarInput11], input11) && smRead(LightbarControlBits[eLightbar1][eLightbarInput12], input12))
	{
		// Determine current state
		bool leftOn  = ((input11 == eLightbarState6) || (input11 == eLightbarState3));
		bool rightOn = ((input11 == eLightbarState6) || (input12 == eLightbarState3));
	
		// Toggle left traffic advisor
		rightOn = !rightOn;
		
		// Set lightbar inputs
		LightbarSetTrafficAdvisor(leftOn, rightOn);
	}
}

void LightbarSetTrafficAdvisor(bool leftOn, bool rightOn)
{
	if (leftOn == true && rightOn == true) // Both on
	{
		LightbarSetState(eLightbar1, eLightbarInput11, eLightbarState6, false);
		LightbarSetState(eLightbar1, eLightbarInput12, eLightbarStateOff, true);
		LightbarSetState(eLightbar3, eLightbarInput11, eLightbarState6, false);
		LightbarSetState(eLightbar3, eLightbarInput12, eLightbarStateOff, true);
		LightbarSetState(eLightbar4, eLightbarInput11, eLightbarState6, false);
		LightbarSetState(eLightbar4, eLightbarInput12, eLightbarStateOff, true);
	}
	else // One or both off
	{
		LightbarSetState(eLightbar1, eLightbarInput11, (leftOn ? eLightbarState3 : eLightbarStateOff), false);
		LightbarSetState(eLightbar1, eLightbarInput12, (rightOn ? eLightbarState3 : eLightbarStateOff), true);
		LightbarSetState(eLightbar3, eLightbarInput11, (leftOn ? eLightbarState3 : eLightbarStateOff), false);
		LightbarSetState(eLightbar3, eLightbarInput12, (rightOn ? eLightbarState3 : eLightbarStateOff), true);
		LightbarSetState(eLightbar4, eLightbarInput11, (leftOn ? eLightbarState3 : eLightbarStateOff), false);
		LightbarSetState(eLightbar4, eLightbarInput12, (rightOn ? eLightbarState3 : eLightbarStateOff), true);
	}
}

void J1939_Chassis_Left_Turn_Changed () { LightbarChassisSetLeftRight(); }
void J1939_Chassis_Right_Turn_Changed () { LightbarChassisSetLeftRight(); }
void LightbarChassisSetLeftRight()
{
	LightbarStateEnum state = eLightbarStateOff;
	
	int left, right;
	if (smRead(VariableIDs.J1939_Chassis_Left_Turn, left) && smRead(VariableIDs.J1939_Chassis_Right_Turn, right))
	{
		if (left == 1 && right == 0)
			state = eLightbarState1;
		else if (left == 0 && right == 1)
			state = eLightbarState2;
		else if (left == 1 && right == 1)
			state = eLightbarState3;
	}
	
	LightbarSetState(eLightbar1, eLightbarInput08, state, true);
	LightbarSetState(eLightbar3, eLightbarInput08, state, true);
	LightbarSetState(eLightbar4, eLightbarInput08, state, true);
}

void J1939_Chassis_Brake_Light_Changed ()
{
	LightbarStateEnum state = eLightbarStateOff;
	
	int value;
	if (smRead(VariableIDs.J1939_Chassis_Brake_Light, value) && value == 1)
		state = eLightbarState1;
	
	LightbarSetState(eLightbar1, eLightbarInput09, state, true);
	LightbarSetState(eLightbar3, eLightbarInput09, state, true);
	LightbarSetState(eLightbar4, eLightbarInput09, state, true);
}

void J1939_Chassis_High_Beam_Changed () { LightbarChassisMarkerBitsChanged(); }
void J1939_Chassis_Low_Beam_Changed () { LightbarChassisMarkerBitsChanged(); }
void J1939_Chassis_Marker_Light_Changed () { LightbarChassisMarkerBitsChanged(); }
void LightbarChassisMarkerBitsChanged()
{
	// If marker flashers are active, ignore chassis lighting command
	if (MarkerFlashersActive() == true)
		return;

	LightbarMarkerFlashersOff();
}


//-----ScriptName=Lightbar Init
enum LightbarEnum
{
	eLightbar1 = 0,
	eLightbar2 = 1,
	eLightbar3 = 2,
	eLightbar4 = 3,
	eLightbarCount
}

enum LightbarInputEnum
{
	eLightbarInput01 = 0,
	eLightbarInput02 = 1,
	eLightbarInput03 = 2,
	eLightbarInput04 = 3,
	eLightbarInput05 = 4,
	eLightbarInput06 = 5,
	eLightbarInput07 = 6,
	eLightbarInput08 = 7,
	eLightbarInput09 = 8,
	eLightbarInput10 = 9,
	eLightbarInput11 = 10,
	eLightbarInput12 = 11,
	eLightbarInput13 = 12,
	eLightbarInput14 = 13,
	eLightbarInput15 = 14,
	eLightbarInput16 = 15,
	eLightbarInput17 = 16,
	eLightbarInput18 = 17,
	eLightbarInputCount
}

enum LightbarStateEnum
{
	eLightbarStateOff = 0,
	eLightbarState1 = 1,
	eLightbarState2 = 2,
	eLightbarState3 = 3,
	eLightbarState4 = 4,
	eLightbarState5 = 5,
	eLightbarState6 = 6,
	eLightbarStateError = 7,
	eLightbarStateCount
}

uint[] LightbarRetryTimer = { TimerIDs.TM_Lightbar1_Retry, TimerIDs.TM_Lightbar2_Retry, TimerIDs.TM_Lightbar3_Retry, TimerIDs.TM_Lightbar4_Retry };
uint[] LightbarControlPgn = { 0xFFAA, 0xFFAB, 0xFFAC, 0xFFAD };

// Can only set 1st dimension size here in Angelscript
// Initialize the rest below
uint[][] LightbarControlBits(eLightbarCount); 
uint[][] LightbarStatusBits(eLightbarCount);
int[][] LightbarRequestedValue(eLightbarCount);

void Screen_ScreenReady ()
{
	//**************************************************************************
	// Lightbar 1
	//**************************************************************************
	
	// Initialize control bits array
	LightbarControlBits[eLightbar1].resize(eLightbarInputCount);
	LightbarControlBits[eLightbar1][eLightbarInput01] = VariableIDs.J1939_Lightbar1_Control01;
	LightbarControlBits[eLightbar1][eLightbarInput02] = VariableIDs.J1939_Lightbar1_Control02;
	LightbarControlBits[eLightbar1][eLightbarInput03] = VariableIDs.J1939_Lightbar1_Control03;
	LightbarControlBits[eLightbar1][eLightbarInput04] = VariableIDs.J1939_Lightbar1_Control04;
	LightbarControlBits[eLightbar1][eLightbarInput05] = VariableIDs.J1939_Lightbar1_Control05;
	LightbarControlBits[eLightbar1][eLightbarInput06] = VariableIDs.J1939_Lightbar1_Control06;
	LightbarControlBits[eLightbar1][eLightbarInput07] = VariableIDs.J1939_Lightbar1_Control07;
	LightbarControlBits[eLightbar1][eLightbarInput08] = VariableIDs.J1939_Lightbar1_Control08;
	LightbarControlBits[eLightbar1][eLightbarInput09] = VariableIDs.J1939_Lightbar1_Control09;
	LightbarControlBits[eLightbar1][eLightbarInput10] = VariableIDs.J1939_Lightbar1_Control10;
	LightbarControlBits[eLightbar1][eLightbarInput11] = VariableIDs.J1939_Lightbar1_Control11;
	LightbarControlBits[eLightbar1][eLightbarInput12] = VariableIDs.J1939_Lightbar1_Control12;
	LightbarControlBits[eLightbar1][eLightbarInput13] = VariableIDs.J1939_Lightbar1_Control13;
	LightbarControlBits[eLightbar1][eLightbarInput14] = VariableIDs.J1939_Lightbar1_Control14;
	LightbarControlBits[eLightbar1][eLightbarInput15] = VariableIDs.J1939_Lightbar1_Control15;
	LightbarControlBits[eLightbar1][eLightbarInput16] = VariableIDs.J1939_Lightbar1_Control16;
	LightbarControlBits[eLightbar1][eLightbarInput17] = VariableIDs.J1939_Lightbar1_Control17;
	LightbarControlBits[eLightbar1][eLightbarInput18] = VariableIDs.J1939_Lightbar1_Control18;
	
	// Initialize status bits array
	LightbarStatusBits[eLightbar1].resize(eLightbarInputCount);
	LightbarStatusBits[eLightbar1][eLightbarInput01] = VariableIDs.J1939_Lightbar1_Status01;
	LightbarStatusBits[eLightbar1][eLightbarInput02] = VariableIDs.J1939_Lightbar1_Status02;
	LightbarStatusBits[eLightbar1][eLightbarInput03] = VariableIDs.J1939_Lightbar1_Status03;
	LightbarStatusBits[eLightbar1][eLightbarInput04] = VariableIDs.J1939_Lightbar1_Status04;
	LightbarStatusBits[eLightbar1][eLightbarInput05] = VariableIDs.J1939_Lightbar1_Status05;
	LightbarStatusBits[eLightbar1][eLightbarInput06] = VariableIDs.J1939_Lightbar1_Status06;
	LightbarStatusBits[eLightbar1][eLightbarInput07] = VariableIDs.J1939_Lightbar1_Status07;
	LightbarStatusBits[eLightbar1][eLightbarInput08] = VariableIDs.J1939_Lightbar1_Status08;
	LightbarStatusBits[eLightbar1][eLightbarInput09] = VariableIDs.J1939_Lightbar1_Status09;
	LightbarStatusBits[eLightbar1][eLightbarInput10] = VariableIDs.J1939_Lightbar1_Status10;
	LightbarStatusBits[eLightbar1][eLightbarInput11] = VariableIDs.J1939_Lightbar1_Status11;
	LightbarStatusBits[eLightbar1][eLightbarInput12] = VariableIDs.J1939_Lightbar1_Status12;
	LightbarStatusBits[eLightbar1][eLightbarInput13] = VariableIDs.J1939_Lightbar1_Status13;
	LightbarStatusBits[eLightbar1][eLightbarInput14] = VariableIDs.J1939_Lightbar1_Status14;
	LightbarStatusBits[eLightbar1][eLightbarInput15] = VariableIDs.J1939_Lightbar1_Status15;
	LightbarStatusBits[eLightbar1][eLightbarInput16] = VariableIDs.J1939_Lightbar1_Status16;
	LightbarStatusBits[eLightbar1][eLightbarInput17] = VariableIDs.J1939_Lightbar1_Status17;
	LightbarStatusBits[eLightbar1][eLightbarInput18] = VariableIDs.J1939_Lightbar1_Status18;
	
	// Initialize requested values array
	LightbarRequestedValue[eLightbar1].resize(eLightbarInputCount);
	for (int i = 0; i < eLightbarInputCount; ++i)
		LightbarRequestedValue[eLightbar1][i] = -1;
		
		
	//**************************************************************************
	// Lightbar 2
	//**************************************************************************
	
	// Initialize control bits array
	LightbarControlBits[eLightbar2].resize(eLightbarInputCount);
	LightbarControlBits[eLightbar2][eLightbarInput01] = VariableIDs.J1939_Lightbar2_Control01;
	LightbarControlBits[eLightbar2][eLightbarInput02] = VariableIDs.J1939_Lightbar2_Control02;
	LightbarControlBits[eLightbar2][eLightbarInput03] = VariableIDs.J1939_Lightbar2_Control03;
	LightbarControlBits[eLightbar2][eLightbarInput04] = VariableIDs.J1939_Lightbar2_Control04;
	LightbarControlBits[eLightbar2][eLightbarInput05] = VariableIDs.J1939_Lightbar2_Control05;
	LightbarControlBits[eLightbar2][eLightbarInput06] = VariableIDs.J1939_Lightbar2_Control06;
	LightbarControlBits[eLightbar2][eLightbarInput07] = VariableIDs.J1939_Lightbar2_Control07;
	LightbarControlBits[eLightbar2][eLightbarInput08] = VariableIDs.J1939_Lightbar2_Control08;
	LightbarControlBits[eLightbar2][eLightbarInput09] = VariableIDs.J1939_Lightbar2_Control09;
	LightbarControlBits[eLightbar2][eLightbarInput10] = VariableIDs.J1939_Lightbar2_Control10;
	LightbarControlBits[eLightbar2][eLightbarInput11] = VariableIDs.J1939_Lightbar2_Control11;
	LightbarControlBits[eLightbar2][eLightbarInput12] = VariableIDs.J1939_Lightbar2_Control12;
	LightbarControlBits[eLightbar2][eLightbarInput13] = VariableIDs.J1939_Lightbar2_Control13;
	LightbarControlBits[eLightbar2][eLightbarInput14] = VariableIDs.J1939_Lightbar2_Control14;
	LightbarControlBits[eLightbar2][eLightbarInput15] = VariableIDs.J1939_Lightbar2_Control15;
	LightbarControlBits[eLightbar2][eLightbarInput16] = VariableIDs.J1939_Lightbar2_Control16;
	LightbarControlBits[eLightbar2][eLightbarInput17] = VariableIDs.J1939_Lightbar2_Control17;
	LightbarControlBits[eLightbar2][eLightbarInput18] = VariableIDs.J1939_Lightbar2_Control18;
	
	// Initialize status bits array
	LightbarStatusBits[eLightbar2].resize(eLightbarInputCount);
	LightbarStatusBits[eLightbar2][eLightbarInput01] = VariableIDs.J1939_Lightbar2_Status01;
	LightbarStatusBits[eLightbar2][eLightbarInput02] = VariableIDs.J1939_Lightbar2_Status02;
	LightbarStatusBits[eLightbar2][eLightbarInput03] = VariableIDs.J1939_Lightbar2_Status03;
	LightbarStatusBits[eLightbar2][eLightbarInput04] = VariableIDs.J1939_Lightbar2_Status04;
	LightbarStatusBits[eLightbar2][eLightbarInput05] = VariableIDs.J1939_Lightbar2_Status05;
	LightbarStatusBits[eLightbar2][eLightbarInput06] = VariableIDs.J1939_Lightbar2_Status06;
	LightbarStatusBits[eLightbar2][eLightbarInput07] = VariableIDs.J1939_Lightbar2_Status07;
	LightbarStatusBits[eLightbar2][eLightbarInput08] = VariableIDs.J1939_Lightbar2_Status08;
	LightbarStatusBits[eLightbar2][eLightbarInput09] = VariableIDs.J1939_Lightbar2_Status09;
	LightbarStatusBits[eLightbar2][eLightbarInput10] = VariableIDs.J1939_Lightbar2_Status10;
	LightbarStatusBits[eLightbar2][eLightbarInput11] = VariableIDs.J1939_Lightbar2_Status11;
	LightbarStatusBits[eLightbar2][eLightbarInput12] = VariableIDs.J1939_Lightbar2_Status12;
	LightbarStatusBits[eLightbar2][eLightbarInput13] = VariableIDs.J1939_Lightbar2_Status13;
	LightbarStatusBits[eLightbar2][eLightbarInput14] = VariableIDs.J1939_Lightbar2_Status14;
	LightbarStatusBits[eLightbar2][eLightbarInput15] = VariableIDs.J1939_Lightbar2_Status15;
	LightbarStatusBits[eLightbar2][eLightbarInput16] = VariableIDs.J1939_Lightbar2_Status16;
	LightbarStatusBits[eLightbar2][eLightbarInput17] = VariableIDs.J1939_Lightbar2_Status17;
	LightbarStatusBits[eLightbar2][eLightbarInput18] = VariableIDs.J1939_Lightbar2_Status18;
	
	// Initialize requested values array
	LightbarRequestedValue[eLightbar2].resize(eLightbarInputCount);
	for (int i = 0; i < eLightbarInputCount; ++i)
		LightbarRequestedValue[eLightbar2][i] = -1;
		
		
	//**************************************************************************
	// Lightbar 3
	//**************************************************************************
	
	// Initialize control bits array
	LightbarControlBits[eLightbar3].resize(eLightbarInputCount);
	LightbarControlBits[eLightbar3][eLightbarInput01] = VariableIDs.J1939_Lightbar3_Control01;
	LightbarControlBits[eLightbar3][eLightbarInput02] = VariableIDs.J1939_Lightbar3_Control02;
	LightbarControlBits[eLightbar3][eLightbarInput03] = VariableIDs.J1939_Lightbar3_Control03;
	LightbarControlBits[eLightbar3][eLightbarInput04] = VariableIDs.J1939_Lightbar3_Control04;
	LightbarControlBits[eLightbar3][eLightbarInput05] = VariableIDs.J1939_Lightbar3_Control05;
	LightbarControlBits[eLightbar3][eLightbarInput06] = VariableIDs.J1939_Lightbar3_Control06;
	LightbarControlBits[eLightbar3][eLightbarInput07] = VariableIDs.J1939_Lightbar3_Control07;
	LightbarControlBits[eLightbar3][eLightbarInput08] = VariableIDs.J1939_Lightbar3_Control08;
	LightbarControlBits[eLightbar3][eLightbarInput09] = VariableIDs.J1939_Lightbar3_Control09;
	LightbarControlBits[eLightbar3][eLightbarInput10] = VariableIDs.J1939_Lightbar3_Control10;
	LightbarControlBits[eLightbar3][eLightbarInput11] = VariableIDs.J1939_Lightbar3_Control11;
	LightbarControlBits[eLightbar3][eLightbarInput12] = VariableIDs.J1939_Lightbar3_Control12;
	LightbarControlBits[eLightbar3][eLightbarInput13] = VariableIDs.J1939_Lightbar3_Control13;
	LightbarControlBits[eLightbar3][eLightbarInput14] = VariableIDs.J1939_Lightbar3_Control14;
	LightbarControlBits[eLightbar3][eLightbarInput15] = VariableIDs.J1939_Lightbar3_Control15;
	LightbarControlBits[eLightbar3][eLightbarInput16] = VariableIDs.J1939_Lightbar3_Control16;
	LightbarControlBits[eLightbar3][eLightbarInput17] = VariableIDs.J1939_Lightbar3_Control17;
	LightbarControlBits[eLightbar3][eLightbarInput18] = VariableIDs.J1939_Lightbar3_Control18;
	
	// Initialize status bits array
	LightbarStatusBits[eLightbar3].resize(eLightbarInputCount);
	LightbarStatusBits[eLightbar3][eLightbarInput01] = VariableIDs.J1939_Lightbar3_Status01;
	LightbarStatusBits[eLightbar3][eLightbarInput02] = VariableIDs.J1939_Lightbar3_Status02;
	LightbarStatusBits[eLightbar3][eLightbarInput03] = VariableIDs.J1939_Lightbar3_Status03;
	LightbarStatusBits[eLightbar3][eLightbarInput04] = VariableIDs.J1939_Lightbar3_Status04;
	LightbarStatusBits[eLightbar3][eLightbarInput05] = VariableIDs.J1939_Lightbar3_Status05;
	LightbarStatusBits[eLightbar3][eLightbarInput06] = VariableIDs.J1939_Lightbar3_Status06;
	LightbarStatusBits[eLightbar3][eLightbarInput07] = VariableIDs.J1939_Lightbar3_Status07;
	LightbarStatusBits[eLightbar3][eLightbarInput08] = VariableIDs.J1939_Lightbar3_Status08;
	LightbarStatusBits[eLightbar3][eLightbarInput09] = VariableIDs.J1939_Lightbar3_Status09;
	LightbarStatusBits[eLightbar3][eLightbarInput10] = VariableIDs.J1939_Lightbar3_Status10;
	LightbarStatusBits[eLightbar3][eLightbarInput11] = VariableIDs.J1939_Lightbar3_Status11;
	LightbarStatusBits[eLightbar3][eLightbarInput12] = VariableIDs.J1939_Lightbar3_Status12;
	LightbarStatusBits[eLightbar3][eLightbarInput13] = VariableIDs.J1939_Lightbar3_Status13;
	LightbarStatusBits[eLightbar3][eLightbarInput14] = VariableIDs.J1939_Lightbar3_Status14;
	LightbarStatusBits[eLightbar3][eLightbarInput15] = VariableIDs.J1939_Lightbar3_Status15;
	LightbarStatusBits[eLightbar3][eLightbarInput16] = VariableIDs.J1939_Lightbar3_Status16;
	LightbarStatusBits[eLightbar3][eLightbarInput17] = VariableIDs.J1939_Lightbar3_Status17;
	LightbarStatusBits[eLightbar3][eLightbarInput18] = VariableIDs.J1939_Lightbar3_Status18;
	
	// Initialize requested values array
	LightbarRequestedValue[eLightbar3].resize(eLightbarInputCount);
	for (int i = 0; i < eLightbarInputCount; ++i)
		LightbarRequestedValue[eLightbar3][i] = -1;
		
		
	//**************************************************************************
	// Lightbar 4
	//**************************************************************************
	
	// Initialize control bits array
	LightbarControlBits[eLightbar4].resize(eLightbarInputCount);
	LightbarControlBits[eLightbar4][eLightbarInput01] = VariableIDs.J1939_Lightbar4_Control01;
	LightbarControlBits[eLightbar4][eLightbarInput02] = VariableIDs.J1939_Lightbar4_Control02;
	LightbarControlBits[eLightbar4][eLightbarInput03] = VariableIDs.J1939_Lightbar4_Control03;
	LightbarControlBits[eLightbar4][eLightbarInput04] = VariableIDs.J1939_Lightbar4_Control04;
	LightbarControlBits[eLightbar4][eLightbarInput05] = VariableIDs.J1939_Lightbar4_Control05;
	LightbarControlBits[eLightbar4][eLightbarInput06] = VariableIDs.J1939_Lightbar4_Control06;
	LightbarControlBits[eLightbar4][eLightbarInput07] = VariableIDs.J1939_Lightbar4_Control07;
	LightbarControlBits[eLightbar4][eLightbarInput08] = VariableIDs.J1939_Lightbar4_Control08;
	LightbarControlBits[eLightbar4][eLightbarInput09] = VariableIDs.J1939_Lightbar4_Control09;
	LightbarControlBits[eLightbar4][eLightbarInput10] = VariableIDs.J1939_Lightbar4_Control10;
	LightbarControlBits[eLightbar4][eLightbarInput11] = VariableIDs.J1939_Lightbar4_Control11;
	LightbarControlBits[eLightbar4][eLightbarInput12] = VariableIDs.J1939_Lightbar4_Control12;
	LightbarControlBits[eLightbar4][eLightbarInput13] = VariableIDs.J1939_Lightbar4_Control13;
	LightbarControlBits[eLightbar4][eLightbarInput14] = VariableIDs.J1939_Lightbar4_Control14;
	LightbarControlBits[eLightbar4][eLightbarInput15] = VariableIDs.J1939_Lightbar4_Control15;
	LightbarControlBits[eLightbar4][eLightbarInput16] = VariableIDs.J1939_Lightbar4_Control16;
	LightbarControlBits[eLightbar4][eLightbarInput17] = VariableIDs.J1939_Lightbar4_Control17;
	LightbarControlBits[eLightbar4][eLightbarInput18] = VariableIDs.J1939_Lightbar4_Control18;
	
	// Initialize status bits array
	LightbarStatusBits[eLightbar4].resize(eLightbarInputCount);
	LightbarStatusBits[eLightbar4][eLightbarInput01] = VariableIDs.J1939_Lightbar4_Status01;
	LightbarStatusBits[eLightbar4][eLightbarInput02] = VariableIDs.J1939_Lightbar4_Status02;
	LightbarStatusBits[eLightbar4][eLightbarInput03] = VariableIDs.J1939_Lightbar4_Status03;
	LightbarStatusBits[eLightbar4][eLightbarInput04] = VariableIDs.J1939_Lightbar4_Status04;
	LightbarStatusBits[eLightbar4][eLightbarInput05] = VariableIDs.J1939_Lightbar4_Status05;
	LightbarStatusBits[eLightbar4][eLightbarInput06] = VariableIDs.J1939_Lightbar4_Status06;
	LightbarStatusBits[eLightbar4][eLightbarInput07] = VariableIDs.J1939_Lightbar4_Status07;
	LightbarStatusBits[eLightbar4][eLightbarInput08] = VariableIDs.J1939_Lightbar4_Status08;
	LightbarStatusBits[eLightbar4][eLightbarInput09] = VariableIDs.J1939_Lightbar4_Status09;
	LightbarStatusBits[eLightbar4][eLightbarInput10] = VariableIDs.J1939_Lightbar4_Status10;
	LightbarStatusBits[eLightbar4][eLightbarInput11] = VariableIDs.J1939_Lightbar4_Status11;
	LightbarStatusBits[eLightbar4][eLightbarInput12] = VariableIDs.J1939_Lightbar4_Status12;
	LightbarStatusBits[eLightbar4][eLightbarInput13] = VariableIDs.J1939_Lightbar4_Status13;
	LightbarStatusBits[eLightbar4][eLightbarInput14] = VariableIDs.J1939_Lightbar4_Status14;
	LightbarStatusBits[eLightbar4][eLightbarInput15] = VariableIDs.J1939_Lightbar4_Status15;
	LightbarStatusBits[eLightbar4][eLightbarInput16] = VariableIDs.J1939_Lightbar4_Status16;
	LightbarStatusBits[eLightbar4][eLightbarInput17] = VariableIDs.J1939_Lightbar4_Status17;
	LightbarStatusBits[eLightbar4][eLightbarInput18] = VariableIDs.J1939_Lightbar4_Status18;
	
	// Initialize requested values array
	LightbarRequestedValue[eLightbar4].resize(eLightbarInputCount);
	for (int i = 0; i < eLightbarInputCount; ++i)
		LightbarRequestedValue[eLightbar4][i] = -1;
}

//-----ScriptName=Lightbar Receive
void Lightbar1_ParseStatus_CAN1 (CANMessageBuffer @buffer)
{
    if (UnitLocationSelected() == true && IsFrontDisplay() == true) // Only process CAN1 lightbar status message on front display
		LightbarParseStatus(eLightbar1, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32), buffer.CanID);
}

void Lightbar2_ParseStatus_CAN1 (CANMessageBuffer @buffer)
{
    if (UnitLocationSelected() == true && IsFrontDisplay() == true) // Only process CAN1 lightbar status message on front display
		LightbarParseStatus(eLightbar2, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32), buffer.CanID);
}

void Lightbar3_ParseStatus_CAN1 (CANMessageBuffer @buffer)
{
    if (UnitLocationSelected() == true && IsFrontDisplay() == true) // Only process CAN1 lightbar status message on front display
		LightbarParseStatus(eLightbar3, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32), buffer.CanID);
}

void Lightbar4_ParseStatus_CAN1 (CANMessageBuffer @buffer)
{
    if (UnitLocationSelected() == true && IsFrontDisplay() == true) // Only process CAN1 lightbar status message on front display
		LightbarParseStatus(eLightbar4, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32), buffer.CanID);
}

void Lightbar1_ParseStatus_CAN2 (CANMessageBuffer @buffer)
{
	if (UnitLocationSelected() == true && IsFrontDisplay() == false) // Only process CAN2 lightbar status message on back display
		LightbarParseStatus(eLightbar1, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32), buffer.CanID);
}

void Lightbar2_ParseStatus_CAN2 (CANMessageBuffer @buffer)
{
	if (UnitLocationSelected() == true && IsFrontDisplay() == false) // Only process CAN2 lightbar status message on back display
		LightbarParseStatus(eLightbar2, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32), buffer.CanID);
}

void Lightbar3_ParseStatus_CAN2 (CANMessageBuffer @buffer)
{ 
	if (UnitLocationSelected() == true && IsFrontDisplay() == false) // Only process CAN2 lightbar status message on back display
		LightbarParseStatus(eLightbar3, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32), buffer.CanID);
}

void Lightbar4_ParseStatus_CAN2 (CANMessageBuffer @buffer)
{
	if (UnitLocationSelected() == true && IsFrontDisplay() == false) // Only process CAN2 lightbar status message on back display
		LightbarParseStatus(eLightbar4, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32), buffer.CanID);
}

bool UnitLocationSelected()
{
	uint init;
	return (smRead(VariableIDs.Unit_Location_Init, init) && (init != 0));
}

bool IsFrontDisplay()
{
	uint location;
	return (smRead(VariableIDs.Unit_Location, location) && (location == VariableEnumerations.Unit_Location_Front));
}

void LightbarParseStatus(LightbarEnum lightbar, uint64 data, uint id)
{
	// Parse out status bits from CAN data
	int received;
	for (uint i = 0; i < LightbarStatusBits[lightbar].length(); ++i)
	{
		// Write received value to variable
		received = (data >> (i*3)) & 7;
		smWrite(LightbarStatusBits[lightbar][i], received);
		
		// See if received value matches requested value
		if (received == LightbarRequestedValue[lightbar][i])
			LightbarRequestedValue[lightbar][i] = -1; // Clear requested value
	}
	
	// See if there are any requested changes
	bool requestedChanges = false;
	for (uint i = 0; i < LightbarRequestedValue[lightbar].length(); ++i)
		if (LightbarRequestedValue[lightbar][i] != -1)
		{
			requestedChanges = true;
			break;
		}
	
	// If no requested changes, cancel retry timer
	if (requestedChanges == false)
		SendAction(ApplicationIDs.CCM, ActionIDs.CCM_Cancel_Timer, LightbarRetryTimer[lightbar]);
		
	// Sync control bits with received status bits	
	int value;
	for (uint i = 0; i < LightbarControlBits[lightbar].length(); ++i)
		if ((LightbarRequestedValue[lightbar][i] == -1) && smRead(LightbarStatusBits[lightbar][i], value))
			smWrite(LightbarControlBits[lightbar][i], value);
			
	
	// If this is the back display, retransmit lightbar status message from CAN2 onto CAN1 for the front display
	if (UnitLocationSelected() == true && IsFrontDisplay() == false)
	{
		CANMessageInfo info;
	    info.MessageType = CANMessageInfoType.SinglePacketRaw; // Don't use display source address
	    
	    CANMessageBuffer message;
	    message.CanID = id;
	    message.Size = 8;
		for (uint i = 0; i < message.Size; ++i)
			message.WriteInt8(i, data >> (i*8)); // WriteInt32() is broken
	
		SendCANMessage(0, message, info);
	}
}

void Lightbar1_EchoControl (CANMessageBuffer @buffer) { LightbarEchoControl(buffer.CanID, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32)); }
void Lightbar2_EchoControl (CANMessageBuffer @buffer) { LightbarEchoControl(buffer.CanID, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32)); }
void Lightbar3_EchoControl (CANMessageBuffer @buffer) { LightbarEchoControl(buffer.CanID, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32)); }
void Lightbar4_EchoControl (CANMessageBuffer @buffer) { LightbarEchoControl(buffer.CanID, buffer.ReadInt32(0) | (uint64(buffer.ReadInt32(4)) << 32)); }

void LightbarEchoControl(uint id, uint64 data)
{
	// If this is the back display, retransmit control message from CAN1 onto CAN2 for the lightbar
	if (UnitLocationSelected() == true && IsFrontDisplay() == false)
	{
		CANMessageInfo info;
	    info.MessageType = CANMessageInfoType.SinglePacketRaw; // Don't use display source address
	    
	    CANMessageBuffer message;
	    message.CanID = id;
	    message.Size = 8;
		for (uint i = 0; i < message.Size; ++i)
			message.WriteInt8(i, data >> (i*8)); // WriteInt32() is broken
	
		SendCANMessage(1, message, info);
	}
}


//-----ScriptName=Navigation
void Navigate_To_Gauge ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished==1) 
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Gauges_View);
	}
}

void Navigate_To_mVEC ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished==1) 
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_MVEC_View);
	}
}

void Navigate_To_DefaultEmpty ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished==1) 
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Overlay_Layer_Default_Empty_View);
	}
}

void Navigate_To_Boom ()
{
	uint BoomAvaliable;
	smRead(VariableIDs.LMIsystem, BoomAvaliable);
	
	if (BoomAvaliable==1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Boom_View);
	}
	else
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Video_View);
	}
}
//---------------------------------------------------------------------------------------------------------------
 
void SetHomeAsDefault ()
{
	//smWrite(VariableIDs.SetupQuestionsComplete, 1);
	SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Home);

}

void SetmVECAsDefault ()
{
	//smWrite(VariableIDs.SetupQuestionsComplete, 1);
	SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_MVEC_View);
} 

void SetGaugeAsDefault ()
{
	//smWrite(VariableIDs.SetupQuestionsComplete, 1);
	SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Gauges_View);
}

void SetBoomAsDefault ()
{
	//smWrite(VariableIDs.SetupQuestionsComplete, 1);
	SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Boom_View);
}

//-----ScriptName=Button Lock

	//	SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Gauges_View);
	
//These scripts check if the inital setup has been finshed before allowing a button to be pressed. 
//Implemented because buttons can be pressed through the overlay when setup questions are displayed.
//Could let users bypass setup questions.
//Similar checks are in place for the physical buttons, see script "Navigation".
	
//------------------------------------------------------------------------------------------------------------
//Switch Panel
void GoTo_mVEC ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_MVEC_View);
	}
}

//Gauges
void GoTo_Gauges ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Gauges_View);
	}
}

//Video
void GoTo_Video ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Video_View);
	}
}

//Day/Night
void GoTo_DayNight ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		sendEvent(EventIDs.DayNightToggle);
	}
}

//Job Log
void GoTo_JobLog ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Overlay_Layer_Download_Job_Timer_View_1);
	}
}

//Service Reminders
void GoTo_ServiceReminders ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Menu_Layer_Service_Reminders_Page_1_Locked);
	}
}

//Date/Time
void GoTo_DateTime ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Popup_Layer_RTC_Details_View);
	}
}

//Load
void GoTo_Load ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Main_Layer_Default_Boom_View);
	}
}

//Main Menu - Go To
void GoTo_MainMenu ()
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		SendAction(ApplicationIDs.UIApp, ActionIDs.UIApp_Show_View, PageViewIDs.Menu_Layer_Default_Main_Menu_View);
	}
}

//Main Menu - Move Menu
void GoTo_OpenMenu ()	
{
	uint SetupFinished;
	//smRead(VariableIDs.SetupQuestionsComplete, SetupFinished);
	smRead(VariableIDs.StartScreen_Init, SetupFinished);
	
	if (SetupFinished == 1)
	{
		sendEvent(EventIDs.MoveMenuUp);
	}
}
		

//-----ScriptName=Speed Check
//---------------------------------------------------------------------------------------------
// Murphy Scripting
// - Leave EventName as Speed_Check for main script method
//---------------------------------------------------------------------------------------------
void Speed_Check () 
{
	int address;
    double temp;	
	
	smRead(VariableIDs.CANPort1_Address, address);
	
	if (address == 161)
	{
	
		smRead(VariableIDs.J1939_Transmission_Current_Gear, temp);
	
		if (temp != 0)
		{
			//SHUT OFF PTO
			sendEvent(EventIDs.Calculate_MVECButtons_PTO_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_PTO__out_MinusOFF);
			//Shut off Lights
			//WorkUpLights
			sendEvent(EventIDs.Calculate_MVECButtons_WorkUpLights_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_WorkupLights__out_MinusOFF);
			//Tail Lights
			sendEvent(EventIDs.Calculate_MVECButtons_TailLights_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_TailLights__out_MinusOFF);
			//Upper Lights
			sendEvent(EventIDs.Calculate_MVECButtons_UpperLights_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_UpperLights__out_MinusOFF);
			//Underlift Lights
			sendEvent(EventIDs.Calculate_MVECButtons_UnderliftLights_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_UnderliftLights__out_MinusOFF);
			//Aux1
			sendEvent(EventIDs.Calculate_MVECButtons_Aux1_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_Aux1__out_MinusOFF);
			//Aux2
			sendEvent(EventIDs.Calculate_MVECButtons_Aux2_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_Aux2__out_MinusOFF);
			//Swivel Lights
			sendEvent(EventIDs.Calculate_MVECButtons_SwivelLights_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_SwivelLights__out_MinusOFF);
			//Drivers Dock
			sendEvent(EventIDs.Calculate_MVECButtons_DriversDock_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_DriversDock__out_MinusOFF);
			//Passenger Dock
			sendEvent(EventIDs.Calculate_MVECButtons_PassDock_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_PassengerDock__out_MinusOFF);
			
			sendEvent(EventIDs.UpdateMVEC);
		}
	}
}

void Manual_SpeedCheck ()
{


			//Tail Lights
			sendEvent(EventIDs.Calculate_MVECButtons_TailLights_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_WorkupLights__out_MinusOFF);
			//Upper Lights
			sendEvent(EventIDs.Calculate_MVECButtons_UpperLights_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_UnderliftLights__out_MinusOFF);
			//Aux1
			sendEvent(EventIDs.Calculate_MVECButtons_Aux1_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_Aux1__out_MinusOFF);
			//Aux2
			sendEvent(EventIDs.Calculate_MVECButtons_Aux2_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_Aux2__out_MinusOFF);
			//Swivel Lights
			sendEvent(EventIDs.Calculate_MVECButtons_SwivelLights_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_SwivelLights__out_MinusOFF);
			//Drivers Dock
			sendEvent(EventIDs.Calculate_MVECButtons_DriversDock_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_DriversDock__out_MinusOFF);
			//Passenger Dock
			sendEvent(EventIDs.Calculate_MVECButtons_PassDock_Off);
			sendEvent(EventIDs.Calculate_J1939_Transmit_PassengerDock__out_MinusOFF);
			
			sendEvent(EventIDs.UpdateMVEC);
			
}





_ModbusMappingGroupIDs ModbusMappingGroupIDs;
class _ModbusMappingGroupIDs
{

   _ModbusMappingGroupIDs () 
   {

   }
}

_ModbusPort ModbusPort;
class _ModbusPort
{

   _ModbusPort () 
   {

   }
}

_VariableIDs VariableIDs;
class _VariableIDs
{  uint RealTimeClock_Set_Month;
  uint RealTimeClock_Set_isLeapYear;
  uint RealTimeClock_Set_Day;
  uint RealTimeClock_Set_daysInMonth;
  uint RealTimeClock_Set_Year;
  uint CANPort1_Address;
  uint RealTimeClock_Year;
  uint RealTimeClock_Month;
  uint RealTimeClock_Day;
  uint RealTimeClock_Hour;
  uint RealTimeClock_Minute;
  uint JOB_TIMER_Hours;
  uint JOB_TIMER_Minutes;
  uint JOB_TIMER_Seconds;
  uint PTO_TIMER_Hours;
  uint PTO_TIMER_Minutes;
  uint PTO_TIMER_Seconds;
  uint Fuel_Job_Start;
  uint J1939_Engine_Total_Fuel_Used;
  uint Job_Fuel_Used;
  uint MVEC_Location_Names;
  uint J1939_Engine_Alternator_Potential;
  uint Battery_Source;
  uint J1939_Engine_Battery_Potential_Voltage;
  uint J1939_Engine_Electrical_Potential_Voltage;
  uint ServRemCurrentDate;
  uint ServRemActive1;
  uint ServRemActive2;
  uint ServRemActive3;
  uint ServRemActive4;
  uint ServRemActive5;
  uint ServRemActive6;
  uint ServRemActive7;
  uint ServRemActive8;
  uint ServRemActive9;
  uint ServRemActive10;
  uint ServRemActive11;
  uint ServRemActive12;
  uint ServRemActive13;
  uint ServRemActive14;
  uint ServRemActive15;
  uint ServRemActive16;
  uint ServRemActive17;
  uint ServRemActive18;
  uint ServRemActive19;
  uint ServRemActive20;
  uint ServRemInit1;
  uint ServRemInit2;
  uint ServRemInit3;
  uint ServRemInit4;
  uint ServRemInit5;
  uint ServRemInit6;
  uint ServRemInit7;
  uint ServRemInit8;
  uint ServRemInit9;
  uint ServRemInit10;
  uint ServRemInit11;
  uint ServRemInit12;
  uint ServRemInit13;
  uint ServRemInit14;
  uint ServRemInit15;
  uint ServRemInit16;
  uint ServRemInit17;
  uint ServRemInit18;
  uint ServRemInit19;
  uint ServRemInit20;
  uint ServRemTargetHours11;
  uint ServRemTargetHours15;
  uint ServRemTargetHours16;
  uint ServRemRemainder11;
  uint ServRemRemainder15;
  uint ServRemRemainder16;
  uint J1939_Engine_Engine_Total_Hours_of_Operation;
  uint ServRemTargetDate1;
  uint ServRemTargetDate2;
  uint ServRemTargetDate3;
  uint ServRemTargetDate4;
  uint ServRemTargetDate5;
  uint ServRemTargetDate6;
  uint ServRemTargetDate7;
  uint ServRemTargetDate8;
  uint ServRemTargetDate9;
  uint ServRemTargetDate10;
  uint ServRemTargetDate11;
  uint ServRemTargetDate12;
  uint ServRemTargetDate13;
  uint ServRemTargetDate14;
  uint ServRemTargetDate15;
  uint ServRemTargetDate16;
  uint ServRemTargetDate17;
  uint ServRemTargetDate18;
  uint ServRemTargetDate19;
  uint ServRemTargetDate20;
  uint ServRemRemainder1;
  uint ServRemRemainder2;
  uint ServRemRemainder3;
  uint ServRemRemainder4;
  uint ServRemRemainder5;
  uint ServRemRemainder6;
  uint ServRemRemainder7;
  uint ServRemRemainder8;
  uint ServRemRemainder9;
  uint ServRemRemainder10;
  uint ServRemRemainder12;
  uint ServRemRemainder13;
  uint ServRemRemainder14;
  uint ServRemRemainder17;
  uint ServRemRemainder18;
  uint ServRemRemainder19;
  uint ServRemRemainder20;
  uint ServRemPopupData;
  uint ServRemCurrentExpired;
  uint ServRemTotalExpired;
  uint Unit_Location;
  uint IO_Hydraulic_Tempurature;
  uint J1939_Transmit_Hydraulic_Temperature;
  uint J1939_Front_Display_Hydraulic_Temperature;
  uint Access_CodeA;
  uint Access_CodeB;
  uint Access_CodeC;
  uint Access_CodeD;
  uint Access_CodeInput_Selected;
  uint VAR_Disable_DM1;
  uint VAR_DM1FaultCount;
  uint VAR_DM1CurrentFault;
  uint VAR_DM1CurrentAck;
  uint FFC_R260_Master_IO_01;
  uint FFC_R260_Master_IO_02;
  uint FFC_R260_Master_IO_03;
  uint FFC_R260_Master_IO_04;
  uint FFC_R260_Master_IO_05;
  uint FFC_R260_Master_IO_06;
  uint FFC_R260_Master_IO_09;
  uint FFC_R260_Master_IO_10;
  uint FFC_R260_Master_IO_11;
  uint FFC_R260_Master_IO_12;
  uint FFC_R260_Master_IO_13;
  uint FFC_R260_Master_IO_14;
  uint FFC_R260_Master_IO_15;
  uint FFC_R260_Master_IO_16;
  uint FFC_R260_Master_IO_V;
  uint FFC_mVEC1_Relay_01;
  uint FFC_mVEC1_Relay_02;
  uint FFC_mVEC1_Relay_03;
  uint FFC_mVEC1_Relay_04;
  uint FFC_mVEC1_Relay_05;
  uint FFC_mVEC1_Relay_06;
  uint FFC_mVEC1_Relay_07;
  uint FFC_mVEC1_Fuse_01;
  uint FFC_mVEC1_Fuse_02;
  uint FFC_mVEC1_Fuse_03;
  uint FFC_mVEC1_Fuse_04;
  uint FFC_mVEC1_Fuse_06;
  uint FFC_mVEC1_Fuse_07;
  uint FFC_mVEC1_Fuse_08;
  uint FFC_mVEC1_Communication;
  uint FFC_mVEC2_Relay_01;
  uint FFC_mVEC2_Relay_02;
  uint FFC_mVEC2_Relay_03;
  uint FFC_mVEC2_Relay_04;
  uint FFC_mVEC2_Relay_05;
  uint FFC_mVEC2_Relay_06;
  uint FFC_mVEC2_Relay_07;
  uint FFC_mVEC2_Relay_08;
  uint FFC_mVEC2_Fuse_01;
  uint FFC_mVEC2_Fuse_02;
  uint FFC_mVEC2_Fuse_03;
  uint FFC_mVEC2_Fuse_04;
  uint FFC_mVEC2_Fuse_05;
  uint FFC_mVEC2_Fuse_06;
  uint FFC_mVEC2_Fuse_07;
  uint FFC_mVEC2_Fuse_08;
  uint FFC_mVEC2_Communication;
  uint FFC_mVEC3_Relay_01;
  uint FFC_mVEC3_Relay_02;
  uint FFC_mVEC3_Relay_03;
  uint FFC_mVEC3_Relay_04;
  uint FFC_mVEC3_Relay_05;
  uint FFC_mVEC3_Relay_06;
  uint FFC_mVEC3_Relay_07;
  uint FFC_mVEC3_Fuse_01;
  uint FFC_mVEC3_Fuse_02;
  uint FFC_mVEC3_Fuse_03;
  uint FFC_mVEC3_Fuse_04;
  uint FFC_mVEC3_Fuse_06;
  uint FFC_mVEC3_Fuse_07;
  uint FFC_mVEC3_Fuse_08;
  uint FFC_mVEC3_Communication;
  uint J1939_MVEC_PTO__in_;
  uint J1939_MVEC_Charge_Cradle_Warning;
  uint LightButton_Aux1;
  uint LightButton_Aux2;
  uint LightButton_AuxBeacon;
  uint LightButton_BoomLights;
  uint LightButton_DriversDock;
  uint LightButton_MainBeacon;
  uint LightButton_MarkerFlashers;
  uint LightButton_PassengerDock;
  uint LightButton_SwivelLights;
  uint LightButton_TailLights;
  uint LightButton_ToolboxLights;
  uint LightButton_UnderliftLights;
  uint LightButton_UpperLights;
  uint LightButton_WorkUpLights;
  uint J1939_Transmit_PassengerDock__out_;
  uint J1939_Transmit_UnderliftLights__out_;
  uint J1939_Transmit_UpperLights__out_;
  uint J1939_Transmit_MainBeacon__out_;
  uint J1939_Transmit_AuxBeacon__out_;
  uint J1939_Transmit_WorkupLights__out_;
  uint J1939_Transmit_MarkerFlashers__out_;
  uint J1939_Transmit_ToolboxLights__out_;
  uint J1939_Transmit_TailLights__out_;
  uint J1939_Transmit_BoomLights__out_;
  uint J1939_Transmit_DriversDock__out_;
  uint J1939_Transmit_SwivelLights__out_;
  uint J1939_Transmit_Aux1__out_;
  uint J1939_Transmit_Aux2__out_;
  uint BoomTruckType;
  uint Rotator_Enabled;
  uint J1939_Chassis_High_Beam;
  uint J1939_Chassis_Low_Beam;
  uint J1939_Chassis_Marker_Light;
  uint J1939_MVEC_Marker_Flashers__in_;
  uint J1939_Chassis_Left_Turn;
  uint J1939_Chassis_Right_Turn;
  uint J1939_Chassis_Brake_Light;
  uint J1939_Lightbar1_Control01;
  uint J1939_Lightbar1_Control02;
  uint J1939_Lightbar1_Control03;
  uint J1939_Lightbar1_Control04;
  uint J1939_Lightbar1_Control05;
  uint J1939_Lightbar1_Control06;
  uint J1939_Lightbar1_Control07;
  uint J1939_Lightbar1_Control08;
  uint J1939_Lightbar1_Control09;
  uint J1939_Lightbar1_Control10;
  uint J1939_Lightbar1_Control11;
  uint J1939_Lightbar1_Control12;
  uint J1939_Lightbar1_Control13;
  uint J1939_Lightbar1_Control14;
  uint J1939_Lightbar1_Control15;
  uint J1939_Lightbar1_Control16;
  uint J1939_Lightbar1_Control17;
  uint J1939_Lightbar1_Control18;
  uint J1939_Lightbar1_Status01;
  uint J1939_Lightbar1_Status02;
  uint J1939_Lightbar1_Status03;
  uint J1939_Lightbar1_Status04;
  uint J1939_Lightbar1_Status05;
  uint J1939_Lightbar1_Status06;
  uint J1939_Lightbar1_Status07;
  uint J1939_Lightbar1_Status08;
  uint J1939_Lightbar1_Status09;
  uint J1939_Lightbar1_Status10;
  uint J1939_Lightbar1_Status11;
  uint J1939_Lightbar1_Status12;
  uint J1939_Lightbar1_Status13;
  uint J1939_Lightbar1_Status14;
  uint J1939_Lightbar1_Status15;
  uint J1939_Lightbar1_Status16;
  uint J1939_Lightbar1_Status17;
  uint J1939_Lightbar1_Status18;
  uint J1939_Lightbar2_Control01;
  uint J1939_Lightbar2_Control02;
  uint J1939_Lightbar2_Control03;
  uint J1939_Lightbar2_Control04;
  uint J1939_Lightbar2_Control05;
  uint J1939_Lightbar2_Control06;
  uint J1939_Lightbar2_Control07;
  uint J1939_Lightbar2_Control08;
  uint J1939_Lightbar2_Control09;
  uint J1939_Lightbar2_Control10;
  uint J1939_Lightbar2_Control11;
  uint J1939_Lightbar2_Control12;
  uint J1939_Lightbar2_Control13;
  uint J1939_Lightbar2_Control14;
  uint J1939_Lightbar2_Control15;
  uint J1939_Lightbar2_Control16;
  uint J1939_Lightbar2_Control17;
  uint J1939_Lightbar2_Control18;
  uint J1939_Lightbar2_Status01;
  uint J1939_Lightbar2_Status02;
  uint J1939_Lightbar2_Status03;
  uint J1939_Lightbar2_Status04;
  uint J1939_Lightbar2_Status05;
  uint J1939_Lightbar2_Status06;
  uint J1939_Lightbar2_Status07;
  uint J1939_Lightbar2_Status08;
  uint J1939_Lightbar2_Status09;
  uint J1939_Lightbar2_Status10;
  uint J1939_Lightbar2_Status11;
  uint J1939_Lightbar2_Status12;
  uint J1939_Lightbar2_Status13;
  uint J1939_Lightbar2_Status14;
  uint J1939_Lightbar2_Status15;
  uint J1939_Lightbar2_Status16;
  uint J1939_Lightbar2_Status17;
  uint J1939_Lightbar2_Status18;
  uint J1939_Lightbar3_Control01;
  uint J1939_Lightbar3_Control02;
  uint J1939_Lightbar3_Control03;
  uint J1939_Lightbar3_Control04;
  uint J1939_Lightbar3_Control05;
  uint J1939_Lightbar3_Control06;
  uint J1939_Lightbar3_Control07;
  uint J1939_Lightbar3_Control08;
  uint J1939_Lightbar3_Control09;
  uint J1939_Lightbar3_Control10;
  uint J1939_Lightbar3_Control11;
  uint J1939_Lightbar3_Control12;
  uint J1939_Lightbar3_Control13;
  uint J1939_Lightbar3_Control14;
  uint J1939_Lightbar3_Control15;
  uint J1939_Lightbar3_Control16;
  uint J1939_Lightbar3_Control17;
  uint J1939_Lightbar3_Control18;
  uint J1939_Lightbar3_Status01;
  uint J1939_Lightbar3_Status02;
  uint J1939_Lightbar3_Status03;
  uint J1939_Lightbar3_Status04;
  uint J1939_Lightbar3_Status05;
  uint J1939_Lightbar3_Status06;
  uint J1939_Lightbar3_Status07;
  uint J1939_Lightbar3_Status08;
  uint J1939_Lightbar3_Status09;
  uint J1939_Lightbar3_Status10;
  uint J1939_Lightbar3_Status11;
  uint J1939_Lightbar3_Status12;
  uint J1939_Lightbar3_Status13;
  uint J1939_Lightbar3_Status14;
  uint J1939_Lightbar3_Status15;
  uint J1939_Lightbar3_Status16;
  uint J1939_Lightbar3_Status17;
  uint J1939_Lightbar3_Status18;
  uint J1939_Lightbar4_Control01;
  uint J1939_Lightbar4_Control02;
  uint J1939_Lightbar4_Control03;
  uint J1939_Lightbar4_Control04;
  uint J1939_Lightbar4_Control05;
  uint J1939_Lightbar4_Control06;
  uint J1939_Lightbar4_Control07;
  uint J1939_Lightbar4_Control08;
  uint J1939_Lightbar4_Control09;
  uint J1939_Lightbar4_Control10;
  uint J1939_Lightbar4_Control11;
  uint J1939_Lightbar4_Control12;
  uint J1939_Lightbar4_Control13;
  uint J1939_Lightbar4_Control14;
  uint J1939_Lightbar4_Control15;
  uint J1939_Lightbar4_Control16;
  uint J1939_Lightbar4_Control17;
  uint J1939_Lightbar4_Control18;
  uint J1939_Lightbar4_Status01;
  uint J1939_Lightbar4_Status02;
  uint J1939_Lightbar4_Status03;
  uint J1939_Lightbar4_Status04;
  uint J1939_Lightbar4_Status05;
  uint J1939_Lightbar4_Status06;
  uint J1939_Lightbar4_Status07;
  uint J1939_Lightbar4_Status08;
  uint J1939_Lightbar4_Status09;
  uint J1939_Lightbar4_Status10;
  uint J1939_Lightbar4_Status11;
  uint J1939_Lightbar4_Status12;
  uint J1939_Lightbar4_Status13;
  uint J1939_Lightbar4_Status14;
  uint J1939_Lightbar4_Status15;
  uint J1939_Lightbar4_Status16;
  uint J1939_Lightbar4_Status17;
  uint J1939_Lightbar4_Status18;
  uint Unit_Location_Init;
  uint StartScreen_Init;
  uint LMIsystem;
  uint J1939_Transmission_Current_Gear;


   _VariableIDs () 
   {
	RealTimeClock_Set_Month = 220;
	RealTimeClock_Set_isLeapYear = 218;
	RealTimeClock_Set_Day = 215;
	RealTimeClock_Set_daysInMonth = 216;
	RealTimeClock_Set_Year = 222;
	CANPort1_Address = 796;
	RealTimeClock_Year = 223;
	RealTimeClock_Month = 213;
	RealTimeClock_Day = 208;
	RealTimeClock_Hour = 210;
	RealTimeClock_Minute = 212;
	JOB_TIMER_Hours = 307;
	JOB_TIMER_Minutes = 306;
	JOB_TIMER_Seconds = 305;
	PTO_TIMER_Hours = 308;
	PTO_TIMER_Minutes = 309;
	PTO_TIMER_Seconds = 310;
	Fuel_Job_Start = 339;
	J1939_Engine_Total_Fuel_Used = 1015;
	Job_Fuel_Used = 340;
	MVEC_Location_Names = 341;
	J1939_Engine_Alternator_Potential = 1019;
	Battery_Source = 828;
	J1939_Engine_Battery_Potential_Voltage = 960;
	J1939_Engine_Electrical_Potential_Voltage = 1020;
	ServRemCurrentDate = 361;
	ServRemActive1 = 141;
	ServRemActive2 = 142;
	ServRemActive3 = 143;
	ServRemActive4 = 144;
	ServRemActive5 = 378;
	ServRemActive6 = 379;
	ServRemActive7 = 380;
	ServRemActive8 = 381;
	ServRemActive9 = 382;
	ServRemActive10 = 383;
	ServRemActive11 = 145;
	ServRemActive12 = 384;
	ServRemActive13 = 385;
	ServRemActive14 = 386;
	ServRemActive15 = 387;
	ServRemActive16 = 388;
	ServRemActive17 = 389;
	ServRemActive18 = 390;
	ServRemActive19 = 391;
	ServRemActive20 = 392;
	ServRemInit1 = 861;
	ServRemInit2 = 862;
	ServRemInit3 = 863;
	ServRemInit4 = 864;
	ServRemInit5 = 865;
	ServRemInit6 = 866;
	ServRemInit7 = 867;
	ServRemInit8 = 868;
	ServRemInit9 = 869;
	ServRemInit10 = 870;
	ServRemInit11 = 871;
	ServRemInit12 = 872;
	ServRemInit13 = 873;
	ServRemInit14 = 874;
	ServRemInit15 = 875;
	ServRemInit16 = 876;
	ServRemInit17 = 877;
	ServRemInit18 = 878;
	ServRemInit19 = 879;
	ServRemInit20 = 880;
	ServRemTargetHours11 = 786;
	ServRemTargetHours15 = 782;
	ServRemTargetHours16 = 783;
	ServRemRemainder11 = 156;
	ServRemRemainder15 = 372;
	ServRemRemainder16 = 373;
	J1939_Engine_Engine_Total_Hours_of_Operation = 969;
	ServRemTargetDate1 = 829;
	ServRemTargetDate2 = 830;
	ServRemTargetDate3 = 831;
	ServRemTargetDate4 = 832;
	ServRemTargetDate5 = 833;
	ServRemTargetDate6 = 840;
	ServRemTargetDate7 = 841;
	ServRemTargetDate8 = 842;
	ServRemTargetDate9 = 843;
	ServRemTargetDate10 = 844;
	ServRemTargetDate11 = 908;
	ServRemTargetDate12 = 854;
	ServRemTargetDate13 = 855;
	ServRemTargetDate14 = 856;
	ServRemTargetDate15 = 909;
	ServRemTargetDate16 = 910;
	ServRemTargetDate17 = 857;
	ServRemTargetDate18 = 858;
	ServRemTargetDate19 = 859;
	ServRemTargetDate20 = 860;
	ServRemRemainder1 = 152;
	ServRemRemainder2 = 153;
	ServRemRemainder3 = 154;
	ServRemRemainder4 = 155;
	ServRemRemainder5 = 362;
	ServRemRemainder6 = 363;
	ServRemRemainder7 = 364;
	ServRemRemainder8 = 365;
	ServRemRemainder9 = 366;
	ServRemRemainder10 = 367;
	ServRemRemainder12 = 369;
	ServRemRemainder13 = 370;
	ServRemRemainder14 = 371;
	ServRemRemainder17 = 374;
	ServRemRemainder18 = 375;
	ServRemRemainder19 = 376;
	ServRemRemainder20 = 377;
	ServRemPopupData = 394;
	ServRemCurrentExpired = 396;
	ServRemTotalExpired = 395;
	Unit_Location = 904;
	IO_Hydraulic_Tempurature = 1016;
	J1939_Transmit_Hydraulic_Temperature = 1029;
	J1939_Front_Display_Hydraulic_Temperature = 1022;
	Access_CodeA = 407;
	Access_CodeB = 408;
	Access_CodeC = 409;
	Access_CodeD = 410;
	Access_CodeInput_Selected = 411;
	VAR_Disable_DM1 = 538;
	VAR_DM1FaultCount = 536;
	VAR_DM1CurrentFault = 537;
	VAR_DM1CurrentAck = 539;
	FFC_R260_Master_IO_01 = 1031;
	FFC_R260_Master_IO_02 = 1032;
	FFC_R260_Master_IO_03 = 1033;
	FFC_R260_Master_IO_04 = 1034;
	FFC_R260_Master_IO_05 = 1035;
	FFC_R260_Master_IO_06 = 1036;
	FFC_R260_Master_IO_09 = 1037;
	FFC_R260_Master_IO_10 = 1038;
	FFC_R260_Master_IO_11 = 1039;
	FFC_R260_Master_IO_12 = 1040;
	FFC_R260_Master_IO_13 = 1041;
	FFC_R260_Master_IO_14 = 1042;
	FFC_R260_Master_IO_15 = 1043;
	FFC_R260_Master_IO_16 = 1044;
	FFC_R260_Master_IO_V = 1045;
	FFC_mVEC1_Relay_01 = 1046;
	FFC_mVEC1_Relay_02 = 1047;
	FFC_mVEC1_Relay_03 = 1048;
	FFC_mVEC1_Relay_04 = 1049;
	FFC_mVEC1_Relay_05 = 1050;
	FFC_mVEC1_Relay_06 = 1051;
	FFC_mVEC1_Relay_07 = 1052;
	FFC_mVEC1_Fuse_01 = 1053;
	FFC_mVEC1_Fuse_02 = 1054;
	FFC_mVEC1_Fuse_03 = 1055;
	FFC_mVEC1_Fuse_04 = 1056;
	FFC_mVEC1_Fuse_06 = 1057;
	FFC_mVEC1_Fuse_07 = 1058;
	FFC_mVEC1_Fuse_08 = 1059;
	FFC_mVEC1_Communication = 1060;
	FFC_mVEC2_Relay_01 = 1061;
	FFC_mVEC2_Relay_02 = 1062;
	FFC_mVEC2_Relay_03 = 1063;
	FFC_mVEC2_Relay_04 = 1064;
	FFC_mVEC2_Relay_05 = 1065;
	FFC_mVEC2_Relay_06 = 1066;
	FFC_mVEC2_Relay_07 = 1067;
	FFC_mVEC2_Relay_08 = 1068;
	FFC_mVEC2_Fuse_01 = 1069;
	FFC_mVEC2_Fuse_02 = 1070;
	FFC_mVEC2_Fuse_03 = 1071;
	FFC_mVEC2_Fuse_04 = 1072;
	FFC_mVEC2_Fuse_05 = 1073;
	FFC_mVEC2_Fuse_06 = 1074;
	FFC_mVEC2_Fuse_07 = 1075;
	FFC_mVEC2_Fuse_08 = 1076;
	FFC_mVEC2_Communication = 1077;
	FFC_mVEC3_Relay_01 = 1078;
	FFC_mVEC3_Relay_02 = 1079;
	FFC_mVEC3_Relay_03 = 1080;
	FFC_mVEC3_Relay_04 = 1081;
	FFC_mVEC3_Relay_05 = 1082;
	FFC_mVEC3_Relay_06 = 1083;
	FFC_mVEC3_Relay_07 = 1084;
	FFC_mVEC3_Fuse_01 = 1085;
	FFC_mVEC3_Fuse_02 = 1086;
	FFC_mVEC3_Fuse_03 = 1087;
	FFC_mVEC3_Fuse_04 = 1088;
	FFC_mVEC3_Fuse_06 = 1089;
	FFC_mVEC3_Fuse_07 = 1090;
	FFC_mVEC3_Fuse_08 = 1091;
	FFC_mVEC3_Communication = 1092;
	J1939_MVEC_PTO__in_ = 1008;
	J1939_MVEC_Charge_Cradle_Warning = 1021;
	LightButton_Aux1 = 942;
	LightButton_Aux2 = 943;
	LightButton_AuxBeacon = 934;
	LightButton_BoomLights = 940;
	LightButton_DriversDock = 932;
	LightButton_MainBeacon = 933;
	LightButton_MarkerFlashers = 935;
	LightButton_PassengerDock = 931;
	LightButton_SwivelLights = 941;
	LightButton_TailLights = 937;
	LightButton_ToolboxLights = 944;
	LightButton_UnderliftLights = 938;
	LightButton_UpperLights = 936;
	LightButton_WorkUpLights = 939;
	J1939_Transmit_PassengerDock__out_ = 331;
	J1939_Transmit_UnderliftLights__out_ = 336;
	J1939_Transmit_UpperLights__out_ = 337;
	J1939_Transmit_MainBeacon__out_ = 329;
	J1939_Transmit_AuxBeacon__out_ = 325;
	J1939_Transmit_WorkupLights__out_ = 338;
	J1939_Transmit_MarkerFlashers__out_ = 330;
	J1939_Transmit_ToolboxLights__out_ = 335;
	J1939_Transmit_TailLights__out_ = 334;
	J1939_Transmit_BoomLights__out_ = 326;
	J1939_Transmit_DriversDock__out_ = 328;
	J1939_Transmit_SwivelLights__out_ = 333;
	J1939_Transmit_Aux1__out_ = 323;
	J1939_Transmit_Aux2__out_ = 324;
	BoomTruckType = 648;
	Rotator_Enabled = 906;
	J1939_Chassis_High_Beam = 1166;
	J1939_Chassis_Low_Beam = 1168;
	J1939_Chassis_Marker_Light = 1170;
	J1939_MVEC_Marker_Flashers__in_ = 1006;
	J1939_Chassis_Left_Turn = 1167;
	J1939_Chassis_Right_Turn = 1169;
	J1939_Chassis_Brake_Light = 1171;
	J1939_Lightbar1_Control01 = 700;
	J1939_Lightbar1_Control02 = 701;
	J1939_Lightbar1_Control03 = 710;
	J1939_Lightbar1_Control04 = 711;
	J1939_Lightbar1_Control05 = 712;
	J1939_Lightbar1_Control06 = 713;
	J1939_Lightbar1_Control07 = 702;
	J1939_Lightbar1_Control08 = 703;
	J1939_Lightbar1_Control09 = 704;
	J1939_Lightbar1_Control10 = 705;
	J1939_Lightbar1_Control11 = 706;
	J1939_Lightbar1_Control12 = 707;
	J1939_Lightbar1_Control13 = 708;
	J1939_Lightbar1_Control14 = 709;
	J1939_Lightbar1_Control15 = 714;
	J1939_Lightbar1_Control16 = 715;
	J1939_Lightbar1_Control17 = 716;
	J1939_Lightbar1_Control18 = 717;
	J1939_Lightbar1_Status01 = 1094;
	J1939_Lightbar1_Status02 = 1095;
	J1939_Lightbar1_Status03 = 1096;
	J1939_Lightbar1_Status04 = 1097;
	J1939_Lightbar1_Status05 = 1098;
	J1939_Lightbar1_Status06 = 1099;
	J1939_Lightbar1_Status07 = 1100;
	J1939_Lightbar1_Status08 = 1101;
	J1939_Lightbar1_Status09 = 1102;
	J1939_Lightbar1_Status10 = 1103;
	J1939_Lightbar1_Status11 = 1104;
	J1939_Lightbar1_Status12 = 1105;
	J1939_Lightbar1_Status13 = 1106;
	J1939_Lightbar1_Status14 = 1107;
	J1939_Lightbar1_Status15 = 1108;
	J1939_Lightbar1_Status16 = 1109;
	J1939_Lightbar1_Status17 = 1110;
	J1939_Lightbar1_Status18 = 1111;
	J1939_Lightbar2_Control01 = 718;
	J1939_Lightbar2_Control02 = 719;
	J1939_Lightbar2_Control03 = 728;
	J1939_Lightbar2_Control04 = 729;
	J1939_Lightbar2_Control05 = 730;
	J1939_Lightbar2_Control06 = 731;
	J1939_Lightbar2_Control07 = 720;
	J1939_Lightbar2_Control08 = 721;
	J1939_Lightbar2_Control09 = 722;
	J1939_Lightbar2_Control10 = 723;
	J1939_Lightbar2_Control11 = 724;
	J1939_Lightbar2_Control12 = 725;
	J1939_Lightbar2_Control13 = 726;
	J1939_Lightbar2_Control14 = 727;
	J1939_Lightbar2_Control15 = 732;
	J1939_Lightbar2_Control16 = 733;
	J1939_Lightbar2_Control17 = 734;
	J1939_Lightbar2_Control18 = 735;
	J1939_Lightbar2_Status01 = 1112;
	J1939_Lightbar2_Status02 = 1113;
	J1939_Lightbar2_Status03 = 1114;
	J1939_Lightbar2_Status04 = 1115;
	J1939_Lightbar2_Status05 = 1116;
	J1939_Lightbar2_Status06 = 1117;
	J1939_Lightbar2_Status07 = 1118;
	J1939_Lightbar2_Status08 = 1119;
	J1939_Lightbar2_Status09 = 1120;
	J1939_Lightbar2_Status10 = 1121;
	J1939_Lightbar2_Status11 = 1122;
	J1939_Lightbar2_Status12 = 1123;
	J1939_Lightbar2_Status13 = 1124;
	J1939_Lightbar2_Status14 = 1125;
	J1939_Lightbar2_Status15 = 1126;
	J1939_Lightbar2_Status16 = 1127;
	J1939_Lightbar2_Status17 = 1128;
	J1939_Lightbar2_Status18 = 1129;
	J1939_Lightbar3_Control01 = 736;
	J1939_Lightbar3_Control02 = 737;
	J1939_Lightbar3_Control03 = 746;
	J1939_Lightbar3_Control04 = 747;
	J1939_Lightbar3_Control05 = 748;
	J1939_Lightbar3_Control06 = 749;
	J1939_Lightbar3_Control07 = 738;
	J1939_Lightbar3_Control08 = 739;
	J1939_Lightbar3_Control09 = 740;
	J1939_Lightbar3_Control10 = 741;
	J1939_Lightbar3_Control11 = 742;
	J1939_Lightbar3_Control12 = 743;
	J1939_Lightbar3_Control13 = 744;
	J1939_Lightbar3_Control14 = 745;
	J1939_Lightbar3_Control15 = 750;
	J1939_Lightbar3_Control16 = 751;
	J1939_Lightbar3_Control17 = 752;
	J1939_Lightbar3_Control18 = 753;
	J1939_Lightbar3_Status01 = 1130;
	J1939_Lightbar3_Status02 = 1131;
	J1939_Lightbar3_Status03 = 1132;
	J1939_Lightbar3_Status04 = 1133;
	J1939_Lightbar3_Status05 = 1134;
	J1939_Lightbar3_Status06 = 1135;
	J1939_Lightbar3_Status07 = 1136;
	J1939_Lightbar3_Status08 = 1137;
	J1939_Lightbar3_Status09 = 1138;
	J1939_Lightbar3_Status10 = 1139;
	J1939_Lightbar3_Status11 = 1140;
	J1939_Lightbar3_Status12 = 1141;
	J1939_Lightbar3_Status13 = 1142;
	J1939_Lightbar3_Status14 = 1143;
	J1939_Lightbar3_Status15 = 1144;
	J1939_Lightbar3_Status16 = 1145;
	J1939_Lightbar3_Status17 = 1146;
	J1939_Lightbar3_Status18 = 1147;
	J1939_Lightbar4_Control01 = 754;
	J1939_Lightbar4_Control02 = 755;
	J1939_Lightbar4_Control03 = 764;
	J1939_Lightbar4_Control04 = 765;
	J1939_Lightbar4_Control05 = 766;
	J1939_Lightbar4_Control06 = 767;
	J1939_Lightbar4_Control07 = 756;
	J1939_Lightbar4_Control08 = 757;
	J1939_Lightbar4_Control09 = 758;
	J1939_Lightbar4_Control10 = 759;
	J1939_Lightbar4_Control11 = 760;
	J1939_Lightbar4_Control12 = 761;
	J1939_Lightbar4_Control13 = 762;
	J1939_Lightbar4_Control14 = 763;
	J1939_Lightbar4_Control15 = 768;
	J1939_Lightbar4_Control16 = 769;
	J1939_Lightbar4_Control17 = 770;
	J1939_Lightbar4_Control18 = 771;
	J1939_Lightbar4_Status01 = 1148;
	J1939_Lightbar4_Status02 = 1149;
	J1939_Lightbar4_Status03 = 1150;
	J1939_Lightbar4_Status04 = 1151;
	J1939_Lightbar4_Status05 = 1152;
	J1939_Lightbar4_Status06 = 1153;
	J1939_Lightbar4_Status07 = 1154;
	J1939_Lightbar4_Status08 = 1155;
	J1939_Lightbar4_Status09 = 1156;
	J1939_Lightbar4_Status10 = 1157;
	J1939_Lightbar4_Status11 = 1158;
	J1939_Lightbar4_Status12 = 1159;
	J1939_Lightbar4_Status13 = 1160;
	J1939_Lightbar4_Status14 = 1161;
	J1939_Lightbar4_Status15 = 1162;
	J1939_Lightbar4_Status16 = 1163;
	J1939_Lightbar4_Status17 = 1164;
	J1939_Lightbar4_Status18 = 1165;
	Unit_Location_Init = 905;
	StartScreen_Init = 918;
	LMIsystem = 948;
	J1939_Transmission_Current_Gear = 1172;

   }
}

_ListDataType ListDataType;
class _ListDataType
{

   _ListDataType () 
   {

   }
}

_EventIDs EventIDs;
class _EventIDs
{  uint TR_MoveMenu;
  uint SettingsMenu_Rollovers_6;
  uint SettingsMenu_Rollovers_5;
  uint TR_MenuAtTarget;
  uint TR_ShowMenu;
  uint TR_Exit_CloseMenu;
  uint SettingsMenu_Rollovers_OFF;
  uint mountUSBcomplete;
  uint TR_Delay_2;
  uint GoToDownloadComplete;
  uint USB_Not_Connected;
  uint copyToUSBcomplete;
  uint jobReportDeleted;
  uint ServremShowPopUp;
  uint TR_Access_Code_Success;
  uint DB_Access_CodeA_Inc;
  uint DB_Access_CodeB_Inc;
  uint DB_Access_CodeC_Inc;
  uint DB_Access_CodeD_Inc;
  uint DB_Access_CodeA_Dec;
  uint DB_Access_CodeB_Dec;
  uint DB_Access_CodeC_Dec;
  uint DB_Access_CodeD_Dec;
  uint UE_Show_DM1;
  uint UE_Close_DM1_Popup;
  uint SCE_DM1_List;
  uint UE_Hide_DM1_Popup;
  uint Calculate_VideoSize_Overlay_ON;
  uint Calculate_VideoSize_Overlay_OFF;
  uint DayNightToggle;
  uint MoveMenuUp;
  uint Calculate_MVECButtons_PTO_Off;
  uint Calculate_J1939_Transmit_PTO__out_MinusOFF;
  uint Calculate_MVECButtons_WorkUpLights_Off;
  uint Calculate_J1939_Transmit_WorkupLights__out_MinusOFF;
  uint Calculate_MVECButtons_TailLights_Off;
  uint Calculate_J1939_Transmit_TailLights__out_MinusOFF;
  uint Calculate_MVECButtons_UpperLights_Off;
  uint Calculate_J1939_Transmit_UpperLights__out_MinusOFF;
  uint Calculate_MVECButtons_UnderliftLights_Off;
  uint Calculate_J1939_Transmit_UnderliftLights__out_MinusOFF;
  uint Calculate_MVECButtons_Aux1_Off;
  uint Calculate_J1939_Transmit_Aux1__out_MinusOFF;
  uint Calculate_MVECButtons_Aux2_Off;
  uint Calculate_J1939_Transmit_Aux2__out_MinusOFF;
  uint Calculate_MVECButtons_SwivelLights_Off;
  uint Calculate_J1939_Transmit_SwivelLights__out_MinusOFF;
  uint Calculate_MVECButtons_DriversDock_Off;
  uint Calculate_J1939_Transmit_DriversDock__out_MinusOFF;
  uint Calculate_MVECButtons_PassDock_Off;
  uint Calculate_J1939_Transmit_PassengerDock__out_MinusOFF;
  uint UpdateMVEC;


   _EventIDs () 
   {
	TR_MoveMenu = 1549;
	SettingsMenu_Rollovers_6 = 1579;
	SettingsMenu_Rollovers_5 = 1578;
	TR_MenuAtTarget = 1548;
	TR_ShowMenu = 1547;
	TR_Exit_CloseMenu = 1550;
	SettingsMenu_Rollovers_OFF = 1573;
	mountUSBcomplete = 1671;
	TR_Delay_2 = 2045;
	GoToDownloadComplete = 1673;
	USB_Not_Connected = 2042;
	copyToUSBcomplete = 1672;
	jobReportDeleted = 1675;
	ServremShowPopUp = 1936;
	TR_Access_Code_Success = 2110;
	DB_Access_CodeA_Inc = 2086;
	DB_Access_CodeB_Inc = 2088;
	DB_Access_CodeC_Inc = 2090;
	DB_Access_CodeD_Inc = 2092;
	DB_Access_CodeA_Dec = 2087;
	DB_Access_CodeB_Dec = 2089;
	DB_Access_CodeC_Dec = 2091;
	DB_Access_CodeD_Dec = 2093;
	UE_Show_DM1 = 2177;
	UE_Close_DM1_Popup = 2179;
	SCE_DM1_List = 2174;
	UE_Hide_DM1_Popup = 2180;
	Calculate_VideoSize_Overlay_ON = 1484;
	Calculate_VideoSize_Overlay_OFF = 1487;
	DayNightToggle = 1255;
	MoveMenuUp = 1544;
	Calculate_MVECButtons_PTO_Off = 1491;
	Calculate_J1939_Transmit_PTO__out_MinusOFF = 2417;
	Calculate_MVECButtons_WorkUpLights_Off = 1522;
	Calculate_J1939_Transmit_WorkupLights__out_MinusOFF = 1705;
	Calculate_MVECButtons_TailLights_Off = 1510;
	Calculate_J1939_Transmit_TailLights__out_MinusOFF = 1697;
	Calculate_MVECButtons_UpperLights_Off = 1507;
	Calculate_J1939_Transmit_UpperLights__out_MinusOFF = 1703;
	Calculate_MVECButtons_UnderliftLights_Off = 1513;
	Calculate_J1939_Transmit_UnderliftLights__out_MinusOFF = 1701;
	Calculate_MVECButtons_Aux1_Off = 1531;
	Calculate_J1939_Transmit_Aux1__out_MinusOFF = 1679;
	Calculate_MVECButtons_Aux2_Off = 1534;
	Calculate_J1939_Transmit_Aux2__out_MinusOFF = 1681;
	Calculate_MVECButtons_SwivelLights_Off = 1528;
	Calculate_J1939_Transmit_SwivelLights__out_MinusOFF = 1695;
	Calculate_MVECButtons_DriversDock_Off = 1516;
	Calculate_J1939_Transmit_DriversDock__out_MinusOFF = 1687;
	Calculate_MVECButtons_PassDock_Off = 1519;
	Calculate_J1939_Transmit_PassengerDock__out_MinusOFF = 1693;
	UpdateMVEC = 2416;

   }
}

_ActionIDs ActionIDs;
class _ActionIDs
{  uint CCM_Cancel_Timer;
  uint CCM_Start_Timer;
  uint UIApp_Show_View;


   _ActionIDs () 
   {
	CCM_Cancel_Timer = 3112;
	CCM_Start_Timer = 3111;
	UIApp_Show_View = 3468;

   }
}

_ApplicationIDs ApplicationIDs;
class _ApplicationIDs
{  uint CCM;
  uint UIApp;


   _ApplicationIDs () 
   {
	CCM = 3109;
	UIApp = 3467;

   }
}

_ActionData ActionData;
class _ActionData
{

   _ActionData () 
   {

   }
}

_VariableEnumerations VariableEnumerations;
class _VariableEnumerations
{  uint Unit_Location_Back;
  uint Rotator_Enabled_Rotator;
  uint Rotator_Enabled_Integrated;
  uint Unit_Location_Front;


   _VariableEnumerations () 
   {
	Unit_Location_Back = 0;
	Rotator_Enabled_Rotator = 1;
	Rotator_Enabled_Integrated = 0;
	Unit_Location_Front = 1;

   }
}

_TimerIDs TimerIDs;
class _TimerIDs
{  uint TimerVariable_PtoWarningLockout;
  uint TimerVariable_PtoWarningHide;
  uint TimerVariable_T110WarningLockout;
  uint TimerVariable_T110WarningHide;
  uint TM_Lightbar1_Retry;
  uint TM_Lightbar2_Retry;
  uint TM_Lightbar3_Retry;
  uint TM_Lightbar4_Retry;


   _TimerIDs () 
   {
	TimerVariable_PtoWarningLockout = 4623;
	TimerVariable_PtoWarningHide = 4625;
	TimerVariable_T110WarningLockout = 4624;
	TimerVariable_T110WarningHide = 4626;
	TM_Lightbar1_Retry = 4637;
	TM_Lightbar2_Retry = 4638;
	TM_Lightbar3_Retry = 4639;
	TM_Lightbar4_Retry = 4640;

   }
}

_CustomListColumn CustomListColumn;
class _CustomListColumn
{

   _CustomListColumn () 
   {

   }
}

_PersistentVariableIDs PersistentVariableIDs;
class _PersistentVariableIDs
{

   _PersistentVariableIDs () 
   {

   }
}

_IOAnalogOutputIDs IOAnalogOutputIDs;
class _IOAnalogOutputIDs
{

   _IOAnalogOutputIDs () 
   {

   }
}

_IODigitalOutputIDs IODigitalOutputIDs;
class _IODigitalOutputIDs
{

   _IODigitalOutputIDs () 
   {

   }
}

_IORelayIDs IORelayIDs;
class _IORelayIDs
{

   _IORelayIDs () 
   {

   }
}

_IOFrequencyOutputIDs IOFrequencyOutputIDs;
class _IOFrequencyOutputIDs
{

   _IOFrequencyOutputIDs () 
   {

   }
}

_IORelayFunctionIDs IORelayFunctionIDs;
class _IORelayFunctionIDs
{

   _IORelayFunctionIDs () 
   {

   }
}

_SnapshotLoggerIDs SnapshotLoggerIDs;
class _SnapshotLoggerIDs
{

   _SnapshotLoggerIDs () 
   {

   }
}

_CANMessageInfoType CANMessageInfoType;
class _CANMessageInfoType
{  uint SinglePacket;
  uint SinglePacketRaw;


   _CANMessageInfoType () 
   {
	SinglePacket = 2;
	SinglePacketRaw = 3;

   }
}

_FreeFormCANIDs FreeFormCANIDs;
class _FreeFormCANIDs
{

   _FreeFormCANIDs () 
   {

   }
}

_DMMemoryMappingIDs DMMemoryMappingIDs;
class _DMMemoryMappingIDs
{

   _DMMemoryMappingIDs () 
   {

   }
}

_CANPortIDs CANPortIDs;
class _CANPortIDs
{

   _CANPortIDs () 
   {

   }
}

_DMStringIDs DMStringIDs;
class _DMStringIDs
{

   _DMStringIDs () 
   {

   }
}

_PageViewIDs PageViewIDs;
class _PageViewIDs
{  uint Overlay_Layer_MVEC_Warning_PTO_;
  uint Overlay_Layer_MVEC_Warning_T110_Not_in_charge_cradle;
  uint Overlay_Layer_Default_Empty_View;
  uint Main_Layer_Default_Gauges_View;
  uint Main_Layer_Default_MVEC_View;
  uint Main_Layer_Default_Boom_View;
  uint Main_Layer_Default_Video_View;
  uint Main_Layer_Home;
  uint Overlay_Layer_Download_Job_Timer_View_1;
  uint Menu_Layer_Service_Reminders_Page_1_Locked;
  uint Popup_Layer_RTC_Details_View;
  uint Menu_Layer_Default_Main_Menu_View;


   _PageViewIDs () 
   {
	Overlay_Layer_MVEC_Warning_PTO_ = 15036;
	Overlay_Layer_MVEC_Warning_T110_Not_in_charge_cradle = 15038;
	Overlay_Layer_Default_Empty_View = 14983;
	Main_Layer_Default_Gauges_View = 4765;
	Main_Layer_Default_MVEC_View = 4761;
	Main_Layer_Default_Boom_View = 4770;
	Main_Layer_Default_Video_View = 4763;
	Main_Layer_Home = 4769;
	Overlay_Layer_Download_Job_Timer_View_1 = 14997;
	Menu_Layer_Service_Reminders_Page_1_Locked = 7135;
	Popup_Layer_RTC_Details_View = 12754;
	Menu_Layer_Default_Main_Menu_View = 7093;

   }
}

_VideoInputIDs VideoInputIDs;
class _VideoInputIDs
{

   _VideoInputIDs () 
   {

   }
}

_StringIDs StringIDs;
class _StringIDs
{  uint Job_Name;
  uint Job_Date;
  uint Job_Record_Time;
  uint Job_Duration;
  uint PTO_Duration;
  uint Latest_Job_Info;
  uint MVEC_Location_Name;
  uint Access_CodeInvalidTxt;
  uint AccessCode;
  uint STR_DM1_CurrentSource;
  uint STR_DM1_CurrentDescription;
  uint STR_DM1_CurrentCorrection;
  uint STR_BoomTruckName;


   _StringIDs () 
   {
	Job_Name = 731;
	Job_Date = 733;
	Job_Record_Time = 734;
	Job_Duration = 735;
	PTO_Duration = 736;
	Latest_Job_Info = 732;
	MVEC_Location_Name = 737;
	Access_CodeInvalidTxt = 738;
	AccessCode = 739;
	STR_DM1_CurrentSource = 784;
	STR_DM1_CurrentDescription = 782;
	STR_DM1_CurrentCorrection = 783;
	STR_BoomTruckName = 805;

   }
}

_ColorTypes ColorTypes;
class _ColorTypes
{

   _ColorTypes () 
   {

   }
}

_ScreenObjectIDs ScreenObjectIDs;
class _ScreenObjectIDs
{  uint CW_Menu;
  uint TW_DealerCode_Invalid;


   _ScreenObjectIDs () 
   {
	CW_Menu = 7977;
	TW_DealerCode_Invalid = 13152;

   }
}

_SmartObjectIDs SmartObjectIDs;
class _SmartObjectIDs
{

   _SmartObjectIDs () 
   {

   }
}

_AnimationTypes AnimationTypes;
class _AnimationTypes
{

   _AnimationTypes () 
   {

   }
}

_PdmOutputIDs PdmOutputIDs;
class _PdmOutputIDs
{

   _PdmOutputIDs () 
   {

   }
}